@extends('layouts.main')
@section('content')
<style>
    .list-group-item {
    border-left:0;
    border-right: 0;
    border-top: 0;
  }

  .list-group-item:last-child {
    border-radius: 0;
  }

  .select2-container--open {
    z-index: 9999999
}
</style>
@include('partials.breadcrumb', [
'breadcrumbTitle' => 'Export',
'parentUrl' => '/asset-health',
'parentTitle' => 'Asset Health',
])
@include('assets-health.submenu')

<div class="wrapper-content">

    <div class="container-fluid">
        @include('partials.sync-messages')
        <div class="ibox">
            <div class="ibox-title">
              <div class="ibox-tools">
                <h5>Asset Health Report Export</h5>
                <a data-toggle="collapse" class="collapse-link" href="#downloadReport"><i class="icon icon-e-delete"></i></a>
              </div>
            </div>
            <div class="collapse in" id="downloadReport">
                <div class="ibox-content">
                  <div class="row">
                    <div class="col-md-6">
                      <ul class="list-group">
                        <li class="list-group-item">
                          <a href="#" @if($latestHistory) id="download-report-csv" @else class="no-history" @endif>Assets Heath Report CSV </a>

                          </li>
                          <li class="list-group-item">
                            <a href="/asset-health-report-download-pdf" @if($latestHistory) @else class="no-history" @endif>Assets Heath Report PDF </a>

                            </li>
                      </ul>
                    </div>
                    <div class="col-md-6">
                        <li class="list-group-item">
                          <a href="/asset-health-report-download-excel" @if($latestHistory) @else class="no-history" @endif>Assets Heath Test Detailed Report Excel </a>
                        </li>
                    </div>
                  </div>
                </div>
            </div>
    </div>
    <div class="ibox">
        <div class="ibox-title">
          <div class="ibox-tools">
            <h5>Email Asset Health Report</h5>
            <a data-toggle="collapse" class="collapse-link" href="#emailReport"><i class="icon icon-e-delete"></i></a>
          </div>
        </div>
        <div class="collapse in" id="emailReport">
            <div class="ibox-content">
              <div class="row">

                <div class="col-md-6">
                    <li class="list-group-item">
                      <a href="#" @if($latestHistory) data-toggle="modal" data-target="#sendEmailModal" @else class="no-history" @endif>Email Asset Health Report PDF </a>
                    </li>
                </div>
              </div>
            </div>
        </div>
</div>
<div class="ibox">
    <div class="ibox-title">
      <div class="ibox-tools">
        <h5>Sync Schedule</h5>
        <a data-toggle="collapse" class="collapse-link" href="#scheduleReport"><i class="icon icon-e-delete"></i></a>
      </div>
    </div>
    <div class="collapse in" id="scheduleReport">
        <div class="ibox-content">
          <div class="row">

            <div class="col-md-6">

                <li class="list-group-item">
                    <a href="#" data-toggle="modal" data-target="#scheduleReportModal">Schedule The Weekly Health Score Sync </a>
                </li>
            </div>
          </div>
        </div>
    </div>
</div>

<div class="modal inmodal" id="sendEmailModal"  role="dialog" aria-hidden="true">

  <div class="modal-dialog">

      <div class="modal-content animated fadeIn">

          <div class="modal-header">

              <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span
                  class="sr-only">Close</span></button>

                  <h4 class="modal-title">Email Asset Health Report PDF</h4>

              </div>
              <form class="form-horizontal" action="/send-email-asset-health-pdf-report" method="post" id="send-email-form">
              <div class="modal-body">

                  @include('partials.error')



                      {{csrf_field()}}

                      <div class="form-group">

                          <label class="col-lg-4 control-label">Select Users</label>

                          <div class="col-lg-8">

                            <select required class="filter-field-user form-control" multiple name="users[]" id="users" key="userName" data-placeholder="Select">
                            </select>

                          </div>

                      </div>



              </div>

              <div class="modal-footer">

                  <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                  <button type="submit" class="btn btn-primary" id="submit">Send Email</button>

              </div>
            </form>
          </div>

      </div>

  </div>

  <div class="modal inmodal" id="scheduleReportModal"  role="dialog" aria-hidden="true">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span
                    class="sr-only">Close</span></button>

                    <h4 class="modal-title">Schedule Weekly Health Score Sync</h4>

                </div>
                <form class="form-horizontal" action="/schedule-asset-health-report" method="post" id="schedule-report-form">
                <div class="modal-body">

                    @include('partials.error')



                        {{csrf_field()}}

                        <div class="form-group">

                            <label class="col-lg-4 control-label">Select Weekday</label>

                            <div class="col-lg-8">

                              <select required class="form-control" name="weekly_day" id="weekly_day" data-placeholder="Select">
                                  <option @if($schedule?->weekly_day == 1) selected @endif value="1">Monday</option>
                                  <option @if($schedule?->weekly_day == 2) selected @endif value="2">Tuesday</option>
                                  <option @if($schedule?->weekly_day == 3) selected @endif value="3">Wednesday</option>
                                  <option @if($schedule?->weekly_day == 4) selected @endif value="4">Thursday</option>
                                  <option @if($schedule?->weekly_day == 5) selected @endif value="5">Friday</option>
                                  <option @if($schedule?->weekly_day == 6) selected @endif value="6">Saturday</option>
                                  <option @if($schedule?->weekly_day == 0) selected @endif value="0">Sunday</option>
                              </select>

                            </div>

                        </div>



                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                    <button type="submit" class="btn btn-primary" id="submit">Save</button>

                </div>
              </form>
            </div>

        </div>

    </div>
@stop
@section('after_scripts')
@include('assets-health.scripts.report-export')
@stop