@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', [
'breadcrumbTitle' => 'Dashboard',
'parentUrl' => '/asset-health',
'parentTitle' => 'Asset Health',
])

@include('assets-health.submenu')

<style type="text/css">
    .ibox-title {
        border-top: none !important;
    }

    .form-group,
    .table {
        text-align: left;
    }

    .ibox-tools a {
        color: #4d73be;
    }
</style>

<div class="wrapper-content">
    <div class="container-fluid">

        <form method="post" action="{{ route('assets-health-reports-sync') }}" class="form-inline">
            @csrf
            <button class="btn btn-primary m-r" type="button" id="confirm_sync">Sync</button>
            <span>Last Synced: {{ $latestHistory ? $latestHistory->created_at->format('m/d/Y H:i A') : '' }}</span>
            <div class="alert alert-danger m-t" id="sync-error" style="display: none;">
                <strong>Error!</strong> <span></span>
            </div>
            <div class="alert alert-success m-t" id="sync-success" style="display: none;">
                <strong>Success!</strong> <span></span>
            </div>
        </form>

        <div class="row m-t">

            @if (!empty($assetHealth))
            <div class="col-lg-3">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>Asset Health</h5>
                    </div>
                    <div class="ibox-content">
                        <div id="donutChartContainer" style="position: relative; height: 250px;">
                            <canvas id="donutChart"></canvas>
                            <div id="centerLabel" style="position: absolute; bottom: 25%; left: 50%; transform: translate(-50%, -50%); font-size: 30px;"></div>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            @if (!empty($assetHistories))
            <div class="col-lg-9">
                <div class="ibox">
                    <div class="ibox-title">
                        <h5>Total Issues</h5>
                    </div>
                    <div class="ibox-content">
                        <div id="asset-history-graph" style="height: 250px;"></div>
                    </div>
                </div>
            </div>
            @endif
        </div>


        <div class="row">
            @foreach ($categories as $category)
            <div class="col-lg-4">
                <div class="ibox">
                    <div class="ibox-content">
                        <h4>{{ $category->category_name }}</h4>
                        <a href="/asset-health-reports/{{ $category->slug }}">
                            <h1 class="health-category-count cat-count-{{ $category->category_name }}">
                                {{ $count[$category->category_name] }}</h1>
                            </a>
                            <input type="hidden" id="category-{{ $category->slug }}-id" value="{{ $category->id }}">
                            <div class="row ">
                                <div class="col-xs-12">
                                    <div id="asset-count-{{ $category->slug }}" style="height: 200px;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

            <div class="row">
                <div class="col-lg-3">
                    <div class="ibox match-height-block">
                        <div class="ibox-title">
                            <h5>Assets Reviewed</h5>
                        </div>
                        <div class="ibox-content">

                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Category</th>
                                        <th>No of Assets</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($count as $category => $count)
                                    <tr>
                                        <th scope="row">{{ $loop->index +1 }}</th>
                                        <td>{{ $category }}</td>
                                        <td>{{ $count }}</td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="3">No Issue Found</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="ibox match-height-block">
                        <div class="ibox-title">
                            <h5>Top Issues</h5>
                        </div>
                        <div class="ibox-content">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Issue Type</th>
                                        <th>No of Issues</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($topIssues as $issues)
                                    <tr>
                                        <th scope="row">{{ $loop->index +1 }}</th>
                                        <td><a href="/asset-health-test-detail/{{ $issues->id }}">
                                            {{ $issues->assetHealthTest ? $issues->assetHealthTest->test_name : '' }}
                                        </a></td>
                                        <td>{{ $issues->test_count }}</td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="3">No Issue Found</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>

                            @if (count($topIssues))
                            <a href="/asset-health-reports" class="btn btn-primary">See All</a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <div class="modal inmodal" id="manualSyncModel" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content animated fadeIn">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span
                        class="sr-only">Close</span></button>

                        <h4 class="modal-title">Asset Health Manual Sync</h4>

                    </div>
                    <div class="modal-body">
                        <h4>Are you sure you want to perform a manual sync?</h4>
                        <p>This action will sync data with the latest updates.<p>
                            <p></p><strong>Note: Manual sync is recommended if there are major issue fixes.</strong></p>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-link" data-dismiss="modal">Close</button>
                            <button type="button" id="continue_sync" class="btn btn-primary">Continue</button>
                        </div>
                    </div>
                </div>
            </div>
            @stop
            @section('after_scripts')
            @include('assets-health.scripts.test-detail')
            @include('assets-health.scripts.dashboard')
            @stop
