@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'SHI Assets Mapping', 'parentUrl' => '#', 'parentTitle' => 'SHI'])
@include('asn.shi.shi-submenu')

<div class="wrapper-content">
    <div class="container-fluid">
        @include('partials.success')
        @include('partials.error-list')
        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <h5>Bulk Upload</h5>
                    <a data-toggle="collapse" href="#collapseBulkUpload" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
                </div>
            </div>
            <div class="collapse in" id="collapseBulkUpload">
                <div class="ibox-content">
                    
                    <form class="form-horizontal" action="/shi-hardware-mapping/bulk-upload"
                    method="post" enctype="multipart/form-data">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="form-control" data-trigger="fileinput">
                                    <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                    <span class="fileinput-filename"></span>
                                </div>
                                <span class="input-group-addon btn btn-primary btn-file">
                                    <span class="fileinput-new">Select file</span>
                                    <span class="fileinput-exists">Change</span>
                                    <input type="file" name="bulk_upload_asn_hardware_mapping"
                                    id="bulk_upload_asn_hardware_mapping" required />
                                </span>
                                <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                data-dismiss="fileinput">Remove</a>
                            </div>
                            <a href="template/asn-hardware-mapping-template.csv" class="pull-right">Download Template File</a>
                        </div>
                        <div class="col-lg-4">
                            <input type="submit" class="btn btn-primary" value="Save"> 
                        </div>
                        
                    </div>
                </form>
            </div>
        </div>
    </div>
    @include('asn.shi.partials.filter.filter-shi-hardware-mapping')
    
    <div class="ibox">
        
        
        <div class="ibox-content">
            
            
            @can('Hardware Standards & Technical Specs Edit')
            <div class="row">
                <div class="col-md-12">
                    <p>
                        <a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                        data-target="#addAsnMapping">Add New</a>
                        
                        <a class="btn btn-primary"
                        href="{{route('shi.hardware-mapping.resync')}}">Resync
                        Mapping</a>
                        
                        
                    </p>
                </div>
            </div>
            @endcan
            @include('settings.partials.delete-message')
            @include('settings.partials.success-message')
            <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
            
            <table class="footable collaptable table table-stripped table-hover" data-paging="true"
            data-paging-size="50" data-filter=#filter id="asn-mapping-table">
            
            <thead>
                
                <tr>
                    
                    <th width="10%">#</th>
                    
                    <th style="display: none;" data-visible="false">ID</th>
                    
                    <th width="20%">Manufacturer Part # (SHI)</th>
                    
                    <th width="15%">Asset Type</th>
                    
                    <th width="20%">Manufacturer</th>
                    
                    <th width="20%">Hardware Standard</th>
                    
                    <th width="15%">Tech Specs</th>
                    
                </tr>
                
            </thead>
            
            <tbody>
                
                @include('asn.shi.partials.data.shi-hardware-mapping-data')
                
            </tbody>
            
            <tfoot>
                <tr colspan="6"></tr>
                
                
                
            </tfoot>
            
        </table>
        
    </div>
    
</div>

</div>

</div>

@include('asn.shi.partials.modal.shi-hardware-mapping-modal')
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.vendor_asset_mapping'),'helpTitle'=>config('help-links.help_titles.vendor_asset_mapping')])
@endsection

@section('after_scripts')



@include('asn.shi.partials.scripts.shi-hardware-mapping-scripts')
@stop