@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'ASN - SHI', 'parentUrl' => '#', 'parentTitle' => 'SHI'])
@include('asn.shi.shi-submenu')

<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">

            @include('partials.success')
            @include('partials.sync-messages')
            @include('partials.error-list')

            @include('settings.partials.delete-message')
            <div class="ibox">
                @include('asn.shi.partials.filter.filter-shi-assets')
            </div>
        </div>
        
        <div class="ibox">



            <div class="ibox-title ">
                <div class="row">
                    <div class="col-md-3 form-group">
                        <label>Receive to Location:</label>
                        <select class="filter-field-location form-control" name="location_id" id="location_id"
                            key="room_name" data-placeholder="Select">
                        </select>
                    </div>

                    <div class="col-md-3 form-group">
                        <label>Ticket #:</label>
                        <input type="text" class="form-control" name="ticket" id="ticket" placeholder="Ticket#"
                            autocomplete="off" required="">
                    </div>
                    <div class="col-md-2"><br>
                        <button id="markReceived" class="btn btn-primary">Mark as received</button>

                    </div>
                    <div class="col-md-4 text-right button-group"><br>

                        <a href="#" id="manual-sync" class="btn btn-primary">Manual
                            Sync</a>
                        <a href="#" id="export-asn-asset" class="btn btn-primary">Export to CSV</a>
                    </div>
                </div>
            </div>
            <div class="ibox-content">

                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <table class="footable collaptable table table-stripped table-hover nowrap" data-paging="true" data-paging-size="50"
                    data-filter=#filter id="receive-shi-assets-table">
                    <thead>

                        <tr>

                            <th>#</th>

                            <th> <input type="checkbox" name="checkedAll" id="checkedAll" title="Select All" />
                            </th>

                            <th>Asset Tag # (SHI)</th>

                            <th>Serial # (SHI)</th>

                            <th>PO # (SHI)</th>

                            <th>Asset Type (Teqtivity)</th>

                            <th>Manufacturer Part # (SHI)</th>

                            <th>Hardware Standard (Teqtivity)</th>

                            <th>Tech Specs (Teqtivity)</th>

                            <th>Tracking Number (SHI)</th>

                            <th>Shipment Status</th>

                            <th>Action</th>

                        </tr>

                    </thead>

                    <tbody>


                    </tbody>

                    <tfoot>
                        <tr colspan="12"></tr>

                    </tfoot>

                </table>
            </div>
        </div>
                

            

    </div>

</div>

@include('asn.shi.partials.modal.shi-edit-modal')
@include('asn.shi.partials.modal.shi-delete-modal')
@include('asn.shi.partials.modal.shi-hardware-mapping-modal')
@include('asn.shi.partials.modal.shi-receive-modal')

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.vendor_integration'),'helpTitle'=>config('help-links.help_titles.vendor_integration')])
@endsection

@section('after_scripts')
@include('asn.shi.partials.scripts.shi-scripts')
@include('asn.shi.partials.scripts.shi-hardware-mapping-scripts')
@include('assets.partials.scripts.dropdown-script')

@stop