@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'SHI Accessories Mapping', 'parentUrl' => '#', 'parentTitle' =>
'SHI'])
@include('asn.shi.shi-submenu')
<div class="wrapper-content">
    <div class="container-fluid">
        @include('partials.success')
        @include('partials.error-list')
        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <h5>Bulk Upload</h5>
                    <a data-toggle="collapse" href="#collapseBulkUpload" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
                </div>
            </div>
            <div class="collapse in" id="collapseBulkUpload">
                <div class="ibox-content">
                    
                    <form class="form-horizontal" action="/shi-accessories-mapping/bulk-upload"
                    method="post" enctype="multipart/form-data">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="form-control" data-trigger="fileinput">
                                    <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                    <span class="fileinput-filename"></span>
                                </div>
                                <span class="input-group-addon btn btn-primary btn-file">
                                    <span class="fileinput-new">Select file</span>
                                    <span class="fileinput-exists">Change</span>
                                    <input type="file" name="shi-accessories-mapping-upload"
                                    id="shi-accessories-mapping-upload" required />
                                </span>
                                <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                data-dismiss="fileinput">Remove</a>
                            </div>
                            <a href="template/asn-accessories-mapping-template.csv"
                            class="pull-right">Download Template File</a>
                        </div>
                        <div class="col-lg-4">
                            <input type="submit" class="btn btn-primary" value="Save">
                            
                            
                        </div>
                        
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    
    @include('asn.shi.partials.filter.filter-shi-accessories-mapping')
    
    <div class="ibox"> 
        <div class="ibox-content">
            @can('Hardware Standards & Technical Specs Edit')
            <p><a href="#" class="btn btn-primary" data-toggle="modal" href="#"
                data-target="#addAccessoriesMapping">Add New</a>
                
                <a class="btn btn-primary"
                href="{{route('shi.accessories-mapping.resync')}}">Resync
                Mapping</a>
            </p>
            @endcan
            @include('settings.partials.delete-message')
            @include('settings.partials.success-message')
            <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
            
            <table class="footable collaptable table table-stripped table-hover" data-paging="true" data-paging-size="50" data-filter=#filter id="accessories-mapping-table">
                
                <thead>
                    
                    <tr>
                        
                        <th>#</th>
                        
                        <th style="display: none;" data-visible="false">ID</th>
                        
                        <th>Manufacturer Part # (SHI)</th>
                        <th class="average">Accessory</th>
                    </tr>
                    
                </thead>
                
                <tbody>
                    
                    
                    @include('asn.shi.partials.data.shi-accessories-mapping-data')
                    
                </tbody>
                
                <tfoot>
                    <tr colspan="4"></tr>
                </tfoot>
                
            </table>
        </div>
        
    </div>
    
</div>

</div>


<div class="modal inmodal" id="addAccessoriesMapping" tabindex="-1" role="dialog">
    
    <div class="modal-dialog">
        
        <div class="modal-content animated fadeIn">
            
            <div class="modal-header">
                
                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                    class="sr-only">Close</span></button>
                    
                    <h4 class="modal-title">Add New Mapping</h4>
                    
                </div>
                
                <div class="modal-body">
                    
                    @include('partials.error')
                    
                    <form class="form-horizontal" action="" method="post" id="accessories-mapping-form">
                        
                        {{csrf_field()}}
                        
                        <div class="form-group" id="discryption">
                            
                            <label class="col-lg-4 control-label">Manufacturer Part # (SHI)</label>
                            
                            <div class="col-lg-8">
                                
                                <input type="text" class="form-control" name="description" value="{{old('description')}}"
                                required>
                                
                            </div>
                            
                        </div>
                        
                        <div class="form-group">
                            <label class="col-lg-4 control-label"></label>
                            <div class="col-lg-8"><label>Map to Teqtivity Accessories</label></div>
                        </div>
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Accessory Type</label>
                            
                            <div class="col-lg-8">
                                
                                <select class="form-control make_model add_make_and_model" id="make_and_model_id"
                                name="make_and_model" data-placeholder="Select" required="">
                                <option value="">Select</option>
                                @foreach($hardwareStandards as $hardwareStandard)
                                <option value="{{$hardwareStandard->id}}">{{$hardwareStandard->hardware}}</option>
                                @endforeach
                            </select>
                            
                        </div>
                        
                    </div>
                    
                </form>
                
            </div>
            
            <div class="modal-footer">
                
                <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>
                
                <button type="button" class="btn btn-primary" id="submit">Save</button>
                
            </div>
            
        </div>
        
    </div>
    
</div>

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.vendor_accessories_mapping'),'helpTitle'=>config('help-links.help_titles.vendor_accessories_mapping')])
@endsection

@section('after_scripts')


@include('asn.shi.partials.scripts.shi-accessories-mapping-scripts')
@stop