<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script>
    $(document).ready(function () {
        $.fn.serializeObject = function () {
            var obj = {};
            $.each(this.serializeArray(), function (i, o) {
                var n = o.name, v = o.value;
                obj[n] = obj[n] === undefined ? v
                : $.isArray(obj[n]) ? obj[n].concat(v)
                : [obj[n], v];
            });

            return obj;
        };
        $('.chosen-select').chosen({ width: "100%" });
        $('.make_model').chosen({ width: "100%" });
        $('.select2').select2();

        var table = $('#receive-shi-assets-table').DataTable({
            scrollX: false,
            scrollY: '400px',
            scrollCollapse: true,
            "processing": true,
            "serverSide": true,
            paging: true,
            "pageLength": 50,
            lengthMenu: [
            [50, 100, 200],
            ['50', '100', '200']
            ],
            columnDefs: [
            { orderable: false, targets: '_all' },
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": true,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            "fnDrawCallback": function() {
                $('[data-tooltip="tooltip"]').tooltip({
                    container: "body"
                });

            },
            "fnInitComplete": function (oSettings, json) {
                $("#receive-shi-assets-table_paginate").children().before("<p style='float:left; margin-top: 8px'>Last Sync: {{ $lastSyncDate ?? '' }}</p>")
            },
            "ajax": {
                "url": "{{ route('shi-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#shi-filter-form').serializeObject();
                }
            },
            "columns": [
            { "data": "id" },
            { "data": "checkbox" },
            { "data": "asset_tag" },
            { "data": "serial_no" },
            { "data": "po_no" },
            { "data": "asset_type" },
            { "data": "part_no" },
            { "data": "hardware" },
            { "data": "tech_spec" },
            { "data": "tracking_number" },
            { "data": "shipment_status" },
            { "data": "edit" },
            ]
        });

        $('#export-asn-asset').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/shi-asset-export",
                data: $('#shi-filter-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                    window.navigator.msSaveBlob(blob, "shi-asset.csv");
                    else {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                        a.download = "asn-asset.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });


        $('#manual-sync').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $(".sync-msg").hide();
            $('#manual-sync').hide();
            $('#manual-sync-load').show();
            $("#sync-success-msg").html('Manual sync started.');
            $("#sync-success").show();
            $.ajax({
                type: "POST",
                url: "/shi-asset-sync",
                data: $('#shi-filter-form').serializeObject(),
                dataType: 'json',
                success: function (data) {
                    $('.ajax-loader').hide();
                    $(".sync-msg").hide();
                    $("#sync-success-msg").html('');
                    $('#manual-sync-load').hide();
                    $('#manual-sync').show();
                    if (data == "connection_error\n") {
                        $('#error').show();
                        $('#error p').text('API connection error');
                    } else {
                        $('#sync-success').show();
                        $('#sync-success-msg').text(data);
                    }

                    $('html, body').animate({
                        scrollTop: $("#error").offset().top
                    }, 3000);
                }
            })
        });

        $('#editModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('asset-id');
            $.ajax({
                type: "POST",
                url: "shi-asset-get/" + id,
                success: function (value) {
                    $('#modal_asset_id').val(id);
                    $('#asset_serial_no').val(value['serial_no']);
                    $('#asset_asset_tag').val(value['asset_tag']);
                    $('#asset_description').html(value['description']);
                    $('#asset_po_no').val(value['po']);
                    $('#modal_asset_type').val(value['assettype']);
                    $('#modal_asset_type').trigger("chosen:updated");
                    getHardwareStandards(value['hardware'], value['assettype']);
                    getTechSpecs(value['hardware'], value['techspec'])

                    $('#modal_hardware').val(value['hardware']);
                    $('#modal_tech').val(value['techspec']);


                }
            });
        });

        $('#modal_asset_type').change(function (e) {
            var assettype = this.value;
            getHardwareStandards(0, assettype);
        });

        $('#modal_hardware').change(function (e) {
            getTechSpecs(this.value, 0);
        });

        function getHardwareStandards(currentHardware, assettype) {
            $.ajax({
                type: "POST",
                url: "/shi-asset-get-hardware",
                dataType: 'json',
                data: { assettype: assettype, "_token": "{{ csrf_token() }}" },
                dataType: 'text',
                success: function (outputfromserver) {
                    var data = JSON.parse(outputfromserver);
                    $('#modal_hardware').empty();
                    $('#modal_hardware').append($("<option></option>")
                    .attr("value", "")
                    .text("Select"));
                    $.each(data, function (key, value) {
                        $('#modal_hardware')
                        .append($("<option></option>")
                        .attr("value", key)
                        .text(value));
                    });
                    if (currentHardware != 0) {
                        $('#modal_hardware').val(currentHardware);
                    }
                    $('#modal_hardware').trigger("chosen:updated");

                }
            });
        }

        function getTechSpecs(currentHardware, currentTechSpec) {

            $.ajax({
                type: "POST",
                data: { id: currentHardware },
                url: "/assets-filter/listtechnics",
                success: function (data) {
                    $('#modal_tech').empty().trigger('chosen:updated');

                    $('#modal_tech').append($('<option>', {
                        value: '',
                        text: 'Select'
                    }));

                    $.each(data, function (key, value) {
                        $('#modal_tech').append($('<option>', {
                            value: value.id,
                            text: value.details
                        }));
                    })
                    if (currentTechSpec != 0) {
                        $('#modal_tech').val(currentTechSpec);
                    }
                    $('#modal_tech').trigger("chosen:updated");

                }
            });
        }

        $('#update-asset').click(function () {
            $('#edit-asset-form').submit();
        });

        $('#edit-asset-form').submit(function (e) {
            e.preventDefault();
            $('#error').hide();
            $('#success').hide();
            $.ajax({
                type: "POST",
                url: "/shi-asset-update",
                data: $(this).serializeObject(),
                dataType: 'text',
                success: function (data) {
                    $('#editModal').modal('hide')
                    if (data != 'success') {

                        var response = JSON.parse(data);
                        var errorString = '<ul>';
                            $.each(response, function (key, value) {
                                errorString += '<li>' + value + '</li>';
                            });
                            errorString += '</ul>';

                            $('#error').show();
                            $('#error p').html(errorString);
                            $('html, body').animate({
                                scrollTop: $("#error").offset().top
                            }, 3000);
                        } else {
                            $('#sync-success-msg').text("Updated Successfully");
                            $('#sync-success').show();
                            $('html, body').animate({
                                scrollTop: $("#error").offset().top
                            }, 1000);
                        }
                        $('#shi-filter-form').submit();

                    }
                });

                table.draw();
            });

            $('#deleteAssetModal').on('show.bs.modal', function (e) {
                var id = $(e.relatedTarget).data('id');
                $('#delete-asset-id').val(id);

            });


            $('#delete-asset-form').submit(function (e) {
                e.preventDefault();
                var id = $('#delete-asset-id').val();
                $.ajax({
                    type: "POST",
                    url: "/shi-asset-delete/" + id,
                    success: function (value) {
                        if (value == 'success') {
                            $('#sync-success').show();
                            $('#sync-success-msg').text("Deleted Successfully");
                        } else {
                            $('#error').show();
                            $('#error p').text('Something went wrong. Try again later');
                        }

                        $('html, body').animate({
                            scrollTop: $("#error").offset().top
                        }, 1000);
                        table.draw();

                    }
                });
                $('#deleteAssetModal').modal('toggle');

                table.draw();
            });

            $("#checkedAll").change(function () {
                if (this.checked) {
                    $(".checkSingle").each(function () {
                        if (!$(this).is(':disabled')) {
                            this.checked = true;
                        }
                    })
                } else {
                    $(".checkSingle").each(function () {
                        if (!$(this).is(':disabled')) {
                            this.checked = false;
                        }
                    })
                }
            });

            $(document).on("click", ".checkSingle", function (e) {
                if ($(this).is(":checked")) {
                    var isAllChecked = 0;
                    $(".checkSingle").each(function () {
                        if (!this.checked)
                        isAllChecked = 1;
                    })
                    if (isAllChecked == 0) { $("#checkedAll").prop("checked", true); }
                } else {
                    $("#checkedAll").prop("checked", false);
                }
            });

            $('#markReceived').click(function () {
                $('#error').hide();
                var location = $("#location_id").val();
                var ticket = $("#ticket").val();
                var received = [];
                $("input:checkbox[name=receiveAsset]:checked").each(function () {
                    received.push($(this).val());
                });
                if (location == '') {
                    $('#error').show();
                    $('#error p').text("A location must be selected.");
                    $('html, body').animate({
                        scrollTop: $("#error").offset().top
                    }, 1000);
                }
                /*if(ticket == ''){
                    $('#error').show();
                    $('#error p').text("Ticket is required.");
                    $('html, body').animate({
                        scrollTop: $("#error").offset().top
                    }, 1000);
                }*/
                else if (received.length == 0) {
                    $('#error').show();
                    $('#error p').text("At least one asset must be selected.");
                    $('html, body').animate({
                        scrollTop: $("#error").offset().top
                    }, 1000);
                }

                else {
                    $('.ajax-loader').show();
                    $.ajax({
                        type: 'POST',
                        url: "{{ route('shi.asset-receive') }}",
                        data: { location: location, received: received, ticket: ticket, "_token": "{{ csrf_token() }}" },
                        success: function (data) {
                            if (data != 'Success') {
                                $('#error').show();
                                $('#error p').text(data);
                                $('html, body').animate({
                                    scrollTop: $("#error").offset().top
                                }, 3000);
                            } else {
                                $('#sync-success').show();
                                $('#sync-success-msg').text("Asset(s) recieved to the selected location.");
                                $('html, body').animate({
                                    scrollTop: $("#error").offset().top
                                }, 1000);
                            }
                            $('#shi-filter-form').submit();
                            $('.ajax-loader').hide();
                            $('#location_id').val('');
                            $("#location_id").select2("val", "");
                            $("#ticket").val('');
                        },
                        error: function (data) {
                        }
                    });
                }
            });

            var delay = (function () {
                var timer = 0;
                return function (callback, ms) {
                    clearTimeout(timer);
                    timer = setTimeout(callback, ms);
                };
            })();


            $(".filter").on('change', function () {
                $('#shi-filter-form').submit();
            })

            $('#shi-filter-form').submit(function (e) {
                e.preventDefault();
                table.draw();
            });

            $(".filter-field").each(function () {
                var name = $(this).attr('key');
                $(this).select2({
                    minimumInputLength: 1,
                    multiple: true,
                    ajax: {
                        url: '/get-filter-fields',
                        dataType: "json",
                        data: function (params) {
                            var query = {
                                search: params.term,
                                type: name
                            }
                            return query;
                        },
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },

                    }
                });
            });

            $(".filter-field-location").each(function () {
                var name = $(this).attr('key');
                $(this).select2({
                    minimumInputLength: 1,
                    ajax: {
                        url: '/get-filter-fields-location',
                        dataType: "json",
                        data: function (params) {
                            var query = {
                                search: params.term,
                                type: name
                            }

                            // Query parameters will be ?search=[term]&type=public
                            return query;
                        },
                        processResults: function (data) {
                            // Tranforms the top-level key of the response object from 'items' to 'results'
                            return {
                                results: data
                            };
                        },

                    }
                });
            });
            $("#modal_location_id").change(function () {
                if ($(this).val() != '') {
                    $('#modal_user_id_chosen .chosen-single').css('border', '1px solid #e5e6e7');
                    $('.assigned-user-ajax').val(null).trigger('change');
                    $('#modal_user_id_chosen .chosen-single span').html('Select an Option');
                }
            });

            $("#receive-asset-form").submit(function (e) {
                e.preventDefault();
                $('.chosen-single.chosen-default').css('border', '1px solid #e5e6e7');
            }).validate({
                rules: {
                    // ticket_no: {
                    //     required: true,
                    // },
                    location_id: {
                        required: function (element) {
                            return $("#modal_user_id").val() == '';
                        }
                    },
                    user_id: {
                        required: function (element) {
                            return $("#modal_location_id").val() == '';
                        }
                    }
                },
                messages: {
                    location_id: {
                        required: "Select User or Location",
                    },
                    ticket_no: {
                        required: "Please Add a Ticket",
                    },
                    user_id: {
                        required: "Please Select a User",
                    },
                },
                errorPlacement: function (error, element) {
                    if (element.is('select')) {
                        error.appendTo($('#error_message'));
                        $('.chosen-single.chosen-default').css('border', '1px dotted #cc5965');
                    } else {
                        error.insertAfter(element);
                    }
                },
                submitHandler: function (form) {
                    markSingleItemReceived();
                }
            });


            function markSingleItemReceived() {
                $('.ajax-loader').show();
                var formData = $('#receive-asset-form').serialize();
                $(".sync-msg").hide();
                $(".sync-msg p").text('');
                $.ajax({
                    type: 'POST',
                    url: "{{ url('/shi-single-item-receive') }}",
                    data: formData,

                    success: function (data) {
                        $('#receiveAssetModal').modal('hide');
                        $('#receive-asset-form')[0].reset();
                        $('.assigned-user-ajax').val(null).trigger('change');
                        $('.chosen-single span').html('Select an Option');
                        // console.log(data.status);
                        if (data.status != 'Success') {
                            $('#sync-error').show();
                            $('#sync-error span').text(data.message).css('font-size', '13px');
                            $('html, body').animate({
                                scrollTop: $("#sync-error").offset().top
                            }, 3000);
                        } else {
                            $('#sync-success').show().html;
                            $('#sync-success span').text(data.message).css('font-size', '13px');
                            $('html, body').animate({
                                scrollTop: $("#sync-success").offset().top
                            }, 1000);
                            table.draw();
                        }
                        $('#shi-filter-form').submit();
                        $('.ajax-loader').hide();
                    },
                    error: function (data) { }
                })
            }

        });



        $('body').on('click', '.recieve-asn-asset', function () {
            $('#receive-asset-form #modal_asset_id').val($(this).data('asset'));
        });

        $('.assigned-user-ajax').each(function () {
            allowClear: true,
            $(this).ajaxChosen({
                dataType: 'json',
            }, {
                processItems: function (data) {
                    return data
                },
                generateUrl: function (q) {
                    return '/get-filter-fields-assigned-user?search=' + q;
                },
            }, {
                width: "100%"
            }).change(function () {
                if ($(this).val() != '') {
                    $("#modal_location_id").val('');
                    $('#modal_location_id_chosen .chosen-single').css('border', '1px solid #e5e6e7');
                    $('#modal_location_id_chosen .chosen-single span').html('Select an Option');
                }
                $(this).closest('.form-group').next().find('input').focus();
            });
        });

        function addAsnMapping(description) {
            // $("#addshiMapping").modal({ show: true });
            $("#manf-part").val('').prop('readonly', false);
            if (description) {
                $('#sync_now').val(1);
                $("#manf-part").val(description).prop('readonly', true);
            }
        }
    </script>