<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<script>

    $(document).ready(function() {

        $(".select2").select2();

		$('.chosen-select').chosen({width: "100%"}).change(function() {
		    $(this).closest('.form-group').next().find('input').focus();
        });

        $.fn.serializeObject = function(){
           var obj = {};
            
           $.each( this.serializeArray(), function(i,o){
              var n = o.name, v = o.value;
                
              obj[n] = obj[n] === undefined ? v
                 : $.isArray( obj[n] ) ? obj[n].concat( v )
                 : [ obj[n], v ];
           });
            
           return obj;
        };
        
        var table = $('.footable').DataTable({
            responsive: true,
            scrollCollapse: false,
            scrollX: false,
            scrollY: false,
            "processing": true,
            "serverSide": true,
            "ajax":{
                "url": "{{ route('shi-inventory-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "available_count" },
                { "data": "inbound_count" },
                { "data": "outbound_count" },
                { "data": "manufacturer_part_no" },
                { "data": "product" },
                { "data": "asset_type" },
                { "data": "manufacturer" },
                { "data": "hardware" },
                { "data": "project" },
                { "data": "shi_part_no" },
                { "data": "warehouse" },
            ],
            lengthMenu: [
                [ 50, 100, 200],
                [ '50', '100', '200']
            ],
            columnDefs: [
               { orderable: false, targets: "_all"}
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            
        });

        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({  
                type: "POST",  
                url: "{{ route('shi-inventory-export') }}",  
                data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    var filename = "SHIInventoryReport.csv"
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, filename);
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = filename;
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });

        var delay = (function(){
            var timer = 0;
            return function(callback, ms){
                clearTimeout (timer);
                timer = setTimeout(callback, ms);
            };
        })();

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $(".filter").on('change', function(){
            $('#search-form').submit();
        });

        $(".filter-text").on('keyup', function(){
            delay(function(){
                $('#search-form').submit();
            }, 400 );
        });

        $(".filter-number").on('keyup change', function(){
            if($(this).val() < 0) {
                $(this).val(0);
            }
            delay(function(){
                $('#search-form').submit();
            }, 400 );
        });

        $('.input-group.date').datepicker({
            todayBtn: "linked",
            keyboardNavigation: false,
            forceParse: true,
            calendarWeeks: true,
            autoclose: true,
            clearBtn:true
        });

        $('th .clear').attr('colspan', 8);
    });


</script>