@extends('layouts.main')
@section('content')
@include('asn.presidio.partials.submenu')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Filtered Out Part #s', 'parentUrl' => '#', 'parentTitle' =>
'Presidio'])

<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                @include('partials.success')
                @include('partials.error-list')
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="ibox-tools">
                            <h5>Bulk Upload</h5>
                            <a data-toggle="collapse" href="#collapseBulkUpload" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
                        </div>
                    </div>
                    <div class="collapse in" id="collapseBulkUpload" aria-expanded="true">
                        <div class="ibox-content">
                            <div id="error-div"></div>
                            <form class="form-horizontal m-t-md" action="/presidio-unwanted-parts/bulk-upload" method="post"
                                enctype="multipart/form-data" data-form-role="bulk-upload" data-error-div="#error-div">
                                {{csrf_field()}}
                                <div class="row">
                                    <div class="col-lg-8">
                                        <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                            <div class="form-control" data-trigger="fileinput">
                                                <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                                <span class="fileinput-filename"></span>
                                            </div>
                                            <span class="input-group-addon btn btn-default btn-file">
                                                <span class="fileinput-new">Select file</span>
                                                <span class="fileinput-exists">Change</span>
                                                <input type="file" name="file"
                                                    id="unwanted-parts-bulk-upload" required />
                                            </span>
                                            <a href="#" class="input-group-addon btn btn-default fileinput-exists"
                                                data-dismiss="fileinput">Remove</a>
                                        </div>
                                        <a href="template/asn-unwanted-parts-template.csv" class="pull-right">Download Template File</a>
                                    </div>
                                    <div class="col-lg-4">
                                        <input type="submit" class="btn btn-primary" value="Save">
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                @include('asn.presidio.partials.filter.unwanted-parts-mapping')

                <div class="ibox">
                    <div class="ibox-content">
                        <p><a href="#" class="btn btn-primary" data-toggle="modal" href="#"
                                data-target="#addUnwantedParts">Add New</a>
                            <a class="btn btn-primary" href="{{route('presidio.unwanted-parts.resync')}}">Resync Part
                                #s</a>
                        </p>
                        @include('settings.partials.delete-message')
                        @include('settings.partials.success-message')
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <div id="table-scroll">
                            <div class="table-wrap" style="overflow: hidden; width: 98%">
                                <table class="footable table table-stripped" data-paging="true" data-paging-size="50"
                                    data-filter=#filter id="unwanted-parts-table">

                                    <thead>

                                        <tr>

                                            <th>#</th>

                                            <th style="display: none;" data-visible="false">ID</th>

                                            <th>Manufacturer Part # (Presidio)</th>
                                        </tr>

                                    </thead>

                                    <tbody>

                                        @include('asn.presidio.partials.data.asn-unwanted-parts-data')

                                    </tbody>

                                    <tfoot>

                                        <tr colspan="2"></tr>

                                    </tfoot>

                                </table>
                            </div>
                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

@include('asn.presidio.partials.modal.unwanted-parts')
@stop

@section('after_scripts')
@include('asn.presidio.partials.script.unwanted-parts-scripts')
@include('asn.scripts.common-bulk-upload-scripts')
@stop