@extends('layouts.main')
@section('content')
@include('asn.presidio.partials.submenu')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'ASN - Presidio', 'parentUrl' => '#', 'parentTitle' => 'Presidio'])
<div class="wrapper-content">
    <div class="container-fluid">
        @include('partials.success')
        @include('partials.error-list')

        <div class="ibox">
            @include('asn.presidio.partials.filter.presidio-assets')
        </div>

        <div id="receive-presidio-ibox">
            <div class="ibox">
                <div class="ibox-title">

                    <div class="row">
                        <div class="col-md-3 form-group">
                            <label>Receive to Location:</label>
                            @include('partials.dropdowns.location-warehouse-valid')
                        </div>

                        <div class="col-md-3 form-group">
                            <label>Ticket #:</label>
                            <input type="text" class="form-control" name="ticket" id="ticket" placeholder="Ticket #" autocomplete="off" required="">
                        </div>

                        <div class="col-md-2"><br>
                            <button id="markReceived" class="btn btn-primary">Mark as received</button>

                        </div>

                        <div class="col-md-4 text-right button-group"><br>

                            <a href="#" id="manual-sync" class="btn btn-primary" style="margin-right:10px;">Manual Sync</a>
                            <a href="javascript:void(0)" id="manual-sync-load" class="btn btn-primary"
                            style="display:none;"><i class="icon icon-reload icon-is-spinning"></i></a>
                            <a href="#" id="export-presidio-asset-csv" class="btn btn-primary">Export to CSV</a>
                        </div>
                    </div>
                </div>
                <div class="ibox-content">

                    <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                    @include('partials.sync-messages')
                    @include('settings.partials.delete-message')
                    @include('settings.partials.success-message')

                    <table class="footable table table-stripped nowrap three-col-fixed" data-paging="true"
                    data-paging-size="50" data-filter=#filter  id="receive-presidio-assets-table">

                    <thead>

                        <tr>

                            <th>#</th>

                            <th><input type="checkbox" name="checkedAll" id="checkedAll" title="Select All" /></th>

                            <th>Asset Tag # (Presidio)</th>

                            <th>Serial # (Presidio)</th>

                            <th>PO # (Presidio)</th>

                            <th>Asset Type (Teqtivity)</th>

                            <th>Manufacturer Part # (Presidio)</th>

                            <th>Hardware Standard (Teqtivity)</th>

                            <th>Tech Specs (Teqtivity)</th>

                            <th>City (Presidio)</th>

                            <th>Tracking # (Presidio)</th>

                            <th>Shipment Status</th>

                            <th style="width:78px">Action</th>

                        </tr>

                    </thead>

                    <tbody>

                    </tbody>

                    <tfoot>

                        <tr colspan="12"></tr>

                    </tfoot>

                </table>


            </div>

        </div>
    </div>
</div>

</div>

@include('asn.presidio.partials.modal.presidio-asset-edit')
@include('asn.presidio.partials.modal.delete')
@include('asn.presidio.partials.modal.presidio-hardware-mapping-modal')
@include('asn.presidio.partials.modal.presidio-receive-modal')
@stop

@section('after_scripts')
@include('asn.presidio.partials.script.presidio-scripts')
@stop