<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedColumns.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">

<script>
    $('.select2').select2();
    $(document).ready(function () {
        $.fn.serializeObject = function () {
            var obj = {};
            $.each(this.serializeArray(), function (i, o) {
                var n = o.name, v = o.value;
                obj[n] = obj[n] === undefined ? v
                    : $.isArray(obj[n]) ? obj[n].concat(v)
                        : [obj[n], v];
            });

            return obj;
        };
        $('.chosen-select').chosen({ width: "100%" });
        $('.make_model').chosen({ width: "100%" });

        var table = $('#receive-presidio-assets-table').DataTable({
            fixedHeader:true,
			"scrollX": true,
			fixedColumns: true,
			fixedColumns: {
				left: 3
			},
            "processing": true,
            "serverSide": true,
            paging: true,
            "pageLength": 50,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { orderable: false, targets: '_all' },
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,

            "ajax": {
                "url": "{{ route('presidio-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                    result.form = $('#presidio-filter-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "checkbox" },
                { "data": "asset_tag" },
                { "data": "serial_no" },
                { "data": "po_no" },
                { "data": "asset_type" },
                { "data": "description" },
                { "data": "hardware" },
                { "data": "tech_spec" },
                { 
                    "data": "city",
                    "defaultContent": "N/A" // Handle missing data
                },
                { "data": "tracking_number" },
                { "data": "shipment_status" },
                { "data": "edit" },
            ],
            "fnDrawCallback": function( oSettings ){
                if ( table.page.info().recordsTotal == 0 ) {
                    $("#export-presidio-asset-csv").hide();
                } else {
                    $("#export-presidio-asset-csv").show();
                }
            },
        });

        $('#export-presidio-asset-csv').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/presidio-asset-export",
                data: $('#presidio-filter-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, "presidio-asset.csv");
                    else {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                        a.download = "presidio-asset.csv.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });


        $('#manual-sync').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $(".sync-msg").hide();
            $('#manual-sync').hide();
            $('#manual-sync-load').show();
            $("#sync-success-msg").html('Manual sync started. Please wait, it may take a while..');
            $("#sync-success").show();
            $.ajax({
                type: "POST",
                url: "/presidio-asset-sync",
                data: $('#presidio-filter-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var data = JSON.parse(result);
                    $('.ajax-loader').hide();
                    $(".sync-msg").hide();
                    $("#sync-success-msg").html('');
                    $('#manual-sync-load').hide();
                    if (data.status == 'success') {
                        $("#sync-success-msg").html(data.message);
                        $("#sync-success").show();
                        $('#presidio-filter-form').submit();
                    } else {
                        $("#sync-error-msg").html(data.message);
                        $("#sync-error").show();
                    }
                    $('#manual-sync').show();
                    $('html, body').animate({
                        scrollTop: $("#error").offset().top
                    }, 3000);
                }
            })
        });

        $('#submit').click(function () {
            $('#presidio-mapping-form').submit();
        });

        $("#checkedAll").change(function () {
            if (this.checked) {
                $(".checkSingle").each(function () {
                    if (!$(this).is(':disabled')) {
                        this.checked = true;
                    }
                })
            } else {
                $(".checkSingle").each(function () {
                    if (!$(this).is(':disabled')) {
                        this.checked = false;
                    }
                })
            }
        });

        $(document).on("click", ".checkSingle", function (e) {
            if ($(this).is(":checked")) {
                var isAllChecked = 0;
                $(".checkSingle").each(function () {
                    if (!this.checked)
                        isAllChecked = 1;
                })
                if (isAllChecked == 0) { $("#checkedAll").prop("checked", true); }
            } else {
                $("#checkedAll").prop("checked", false);
            }
        });

        $('#markReceived').click(function () {
            var location = $("#location_id").val();
            var ticket = $("#ticket").val();
            var received = [];
            $("input:checkbox[name=receiveAsset]:checked").each(function () {
                received.push($(this).val());
            });
            if (!location) {
                $('#error').show();
                $('#error .msg').text("Location is required.");
            }
            else if (received.length == 0) {
                $('#error').show();
                $('#error .msg').text("At least one asset must be selected.");
            }

            else {
                $('.ajax-loader').show();
                $.ajax({
                    type: 'POST',
                    url: "{{ route('presidio-asset-receive') }}",
                    data: { location: location, ticket: ticket, received: received, "_token": "{{ csrf_token() }}" },
                    success: function (data) {
                        if (data != 'Success') {
                            $('#error').show();
                            $('#error .msg').text(data);
                        } else {
                            $('#success').show();
                            $('#success .msg').text("Asset(s) changed to Brand New status, and moved to the selected location.");
                            $('#presidio-filter-form').submit();
                            $('#checkedAll').prop('checked', false);
                        }
                        $('.ajax-loader').hide();
                    },
                    error: function (data) {
                    }
                });
            }
        });




        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();


        $(".filter-item").on('change', function () {
            $('#presidio-filter-form').submit();
        })

        $('#presidio-filter-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $(".filter-field").each(function () {
            var name = $(this).attr('key');
            $(this).select2({
                minimumInputLength: 1,
                multiple: true,
                ajax: {
                    url: '/get-filter-fields',
                    dataType: "json",
                    data: function (params) {
                        var query = {
                            search: params.term,
                            type: name
                        }
                        return query;
                    },
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },

                }
            });
        });

        $(".filter-field-location").each(function () {
            var name = $(this).attr('key');
            $(this).select2({
                minimumInputLength: 1,
                ajax: {
                    url: '/get-filter-fields-location',
                    dataType: "json",
                    data: function (params) {
                        var query = {
                            search: params.term,
                            type: name
                        }

                        // Query parameters will be ?search=[term]&type=public
                        return query;
                    },
                    processResults: function (data) {
                        // Tranforms the top-level key of the response object from 'items' to 'results'
                        return {
                            results: data
                        };
                    },

                }
            });
        });

        $('#deleteAssetModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('id');
            $('#delete-asset-id').val(id);

        });

        $('#delete-asset-form').submit(function (e) {
            e.preventDefault();
            var id = $('#delete-asset-id').val();
            $.ajax({
                type: "POST",
                url: "/presidio-asset-delete/" + id,
                success: function (value) {
                    $('#success .msg').text("Deleted Successfully");
                    $('#success').show();
                    table.draw();
                }
            });
            $('#deleteAssetModal').modal('toggle');
        });


        $('#editModal').on('show.bs.modal', function (e) {
            $('.modal-body').find('#error').hide();
            var id = $(e.relatedTarget).data('asset-id');
            $.ajax({
                type: "POST",
                url: "presidio-asset-get/" + id,
                success: function (value) {
                    $('#modal_asset_id').val(id);
                    $('#asset_serial_no').val(value['serial_no']);
                    $('#asset_asset_tag').val(value['asset_tag']);
                    $('#asset_description').html(value['description']);
                    $('#asset_po_no').val(value['po']);

                    $('#modal_asset_type').val(value['assettype']);
                    $('#modal_asset_type').trigger("chosen:updated");
                    getHardwareStandards(value['hardware'], value['assettype']);
                    getTechSpecs(value['hardware'], value['techspec'])

                    $('#modal_hardware').val(value['hardware']);
                    $('#modal_tech').val(value['techspec']);
                }
            });
        });

        function getHardwareStandards(currentHardware, assettype) {
            $.ajax({
                type: "POST",
                url: "/presidio-asset-get-hardware",
                dataType: 'json',
                data: { assettype: assettype, "_token": "{{ csrf_token() }}" },
                dataType: 'text',
                success: function (outputfromserver) {
                    var data = JSON.parse(outputfromserver);
                    $('#modal_hardware').empty();
                    $('#modal_hardware').append($("<option></option>")
                        .attr("value", "")
                        .text("Select"));

                    $.each(data, function (key, value) {
                        $('#modal_hardware')
                            .append($("<option></option>")
                                .attr("value", key)
                                .text(value));
                    });
                    if (currentHardware != 0) {
                        $('#modal_hardware').val(currentHardware);
                    }
                    $('#modal_hardware').trigger("chosen:updated");
                }
            });
        }

        function getTechSpecs(currentHardware, currentTechSpec) {

            $.ajax({
                type: "POST",
                data: { id: currentHardware },
                url: "/assets-filter/listtechnics",
                success: function (data) {
                    $('.modal_tech_spec').empty().trigger('chosen:updated');
                    $('.modal_tech_spec').append($('<option>', {
                        value: '',
                        text: 'Select'
                    }));

                    $.each(data, function (key, value) {
                        $('.modal_tech_spec').append($('<option>', {
                            value: value.id,
                            text: value.details
                        }));
                    })
                    if (currentTechSpec != 0) {
                        $('.modal_tech_spec').val(currentTechSpec);
                    }
                    $('.modal_tech_spec').trigger("chosen:updated");

                }
            });
        }


        $('#modal_asset_type').change(function (e) {
            var assettype = this.value;
            getHardwareStandards(0, assettype);
        });

        $('.modal_hardware').change(function (e) {
            var currentHardware = this.value;
            getTechSpecs(currentHardware, 0);
        });

        $('#update-asset').click(function () {
            $('#edit-asset-form').submit();
        });
        $('#edit-asset-form').submit(function (e) {
            e.preventDefault();
            $('#success').hide();
            $.ajax({
                type: "POST",
                url: "/presidio-asset-update",
                data: $(this).serializeObject(),
                dataType: 'text',
                success: function (data) {
                    var response = JSON.parse(data);
                    if (response.status && response.status == 'success') {
                        handleSuccess("Updated Successfully", '#editModal');
                    } else {
                        handleErrors(response, '#editModal');
                    }
                }
            });
        });

        $("#modal_location_id").change(function () {
            if ($(this).val() != '') {
                $('.chosen-single').css('border', '1px solid #e5e6e7');
                $('.assigned-user-ajax').val(null).trigger('change');
                $('.chosen-single span').html('Select an Option');
            }
        });

        $("#receive-asset-form").submit(function (e) {
            e.preventDefault();
            $('.chosen-single.chosen-default').css('border', '1px solid #e5e6e7');
        }).validate({
            rules: {
                // ticket_no: {
                //     required: true,
                // },
                location_id: {
                    required: function (element) {
                        return $("#modal_user_id").val() == '';
                    }
                },
                user_id: {
                    required: function (element) {
                        return $("#modal_location_id").val() == '';
                    }
                }
            },
            messages: {
                location_id: {
                    required: "Select User or Location",
                },
                ticket_no: {
                    required: "Please Add a Ticket #",
                },
                user_id: {
                    required: "Please Select a User",
                },
            },
            errorPlacement: function (error, element) {
                if (element.is('select')) {
                    error.appendTo($('#error_message'));
                    $('.chosen-single.chosen-default').css('border', '1px dotted #cc5965');
                } else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                markSingleItemReceived();
            }
        });

        $('body').on('click', '.recieve-asn-asset', function () {
            $('#receive-asset-form #modal_asset_id').val($(this).data('asset'));
        });

        $('#presidio-hardware-mapping').click(function () {
            $('#presidio-hardware-mapping-form').submit();
        });

        $('#presidio-hardware-mapping-form').submit(function (e) {
            e.preventDefault();
            $('#success').hide();
            $.ajax({
                type: "POST",
                url: '/presidio-asset-mapping',
                data: $(this).serializeObject(),
                dataType: 'text',
                success: function (data) {
                    var response = JSON.parse(data);
                    if (response.status && response.status == 'success') {
                        handleSuccess("Hardware mapped successfully", '#addAsnMapping');
                    } else {
                        handleErrors(response, '#addAsnMapping');
                    }
                }
            });
        });

        function markSingleItemReceived() {
            $('.ajax-loader').show();
            var formData = $('#receive-asset-form').serialize();
            $.ajax({
                type: 'POST',
                url: "{{ url('/presidio-single-item-receive') }}",
                data: formData,

                success: function (data) {
                    $('#receiveAssetModal').modal('hide');
                    $('#receive-asset-form')[0].reset();
                    $('.assigned-user-ajax').val(null).trigger('change');
                    $('.chosen-single span').html('Select an Option');
                    if (data.status != 'Success') {
                        $('#error').show();
                        $('#error .msg').text(data.message);
                    } else {
                        $('#success').show();
                        $('#success .msg').text(data.message);
                        table.draw();
                    }
                    $('.ajax-loader').hide();
                    $('#presidio-filter-form').submit();
                },
                error: function (data) { }
            })
        }

    });

    $('.assigned-user-ajax').each(function () {
        allowClear: true,
            $(this).ajaxChosen({
                dataType: 'json',
            }, {
                processItems: function (data) {
                    return data
                },
                generateUrl: function (q) {
                    return '/get-filter-fields-assigned-user?search=' + q;
                },
            }, {
                width: "100%"
            }).change(function () {
                if ($(this).val() != '') {
                    $("#modal_location_id").val('');
                    $('.chosen-single').css('border', '1px solid #e5e6e7');
                }
                $(this).closest('.form-group').next().find('input').focus();
            });
    });

    function addAsnMapping(description) {
        $("#addAsnMapping").modal({ show: true });
        $("#manf-part").val('').prop('readonly', false);
        if (description) {
            $("#manf-part").val(description).prop('readonly', true);
        }
    }

    function unmappedAlert(assetsCount) {
        if (assetsCount > 0) {
            $('#unmapped-assets-alert').show();
        } else {
            $('#unmapped-assets-alert').hide();
        }
    }

    function handleSuccess(response, modal) {
        $(modal).modal('hide');

        $('#success .msg').text(response);
        $('#success').show();

        $('#presidio-filter-form').submit();
    }

    function handleErrors(response, modal) {
        var errorString = '<ul>';
        $.each(response, function (key, value) {
            errorString += '<li>' + value + '</li>';
        });
        errorString += '</ul>';

        $(modal + ' .modal-body').find('#error .msg').html(errorString);
        $(modal + ' .modal-body').find('#error').show();
    }
</script>