<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/hardware-filter.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<script>

    @if ($errors -> count() > 0)
        $("#addAccessoriesMapping").modal({ show: true });
    @endif

    $(document).ready(function () {

        $('.chosen-select').chosen({ width: "100%" });
        $('.make_model').chosen({ width: "100%" });

        $('#submit').click(function () {
            $('#accessories-mapping-form').submit();
        });

        $('#accessories-filter-form').submit(function (e) {

            e.preventDefault();
            $('.ajax-loader').show();
            var formData = $(this).serializeArray();

            $('#make_and_model').prop("disabled", true).trigger("chosen:updated");
            $('#technical_spec').prop("disabled", true).trigger("chosen:updated");

            $.ajax({
                type: "POST",
                url: "/presidio-accessories-mapping-search",
                data: formData,
                success: function (value) {

                    $('.ajax-loader').hide();

                    var dataTable = $("#accessories-mapping-table").DataTable();

                    // get the html table rows then
                    if ($.fn.DataTable.isDataTable('#accessories-mapping-table')) {
                        dataTable.clear();
                        dataTable.destroy();
                    }

                    $("tbody").empty().promise().done(function () {
                        $("tbody").html(value.hardware);
                    });

                    $('#accessories-mapping-table').Tabledit({
                        url: '/presidio-accessories-mapping-ajax',
                        columns: {
                            identifier: [1, 'id'],
                            editable: [[2, 'part_no'], [3, 'make_and_model', 'select', JSON.stringify({!!$hardwareStandardsArray!!})]]
                },
                onDraw: function (data) {

                },
                onSuccess: function (data) {
                    if (data == 'error') {

                        $('#error').show();
                        $('#error .msg').text("This cannot be deleted.");
                        $('html, body').animate({
                            scrollTop: $("#error").offset().top
                        }, 1000);
                    }
                },
                restoreButton: false
            });
        },
            error: function (value) {

            }
            })
        .done(function () {
            $('#make_and_model').prop("disabled", false).trigger("chosen:updated");
            $('#technical_spec').prop("disabled", false).trigger("chosen:updated");

            $('#accessories-mapping-table').DataTable(
                {
                    responsive: true,
                    scrollCollapse: false,
                    scrollX: false,
                    scrollY: false,
                    lengthMenu: [
                        [50, 100, 200],
                        ['50', '100', '200']
                    ],
                    columnDefs: [
                        { "width": "10%", "targets": 0 },
                        { "width": "10%", "targets": 1 },
                        { "width": "80%", "targets": 2 },
                        { orderable: false, targets: [4] },
                    ],
                    "order": [[2, "asc"]],
                    "bFilter": false,
                    "bLengthChange": false,
                    "bInfo": false,
                }
            );
        });

        });


    @can('Hardware Standards & Technical Specs Edit')
    $('#accessories-mapping-table').Tabledit({
        url: '/presidio-accessories-mapping-ajax',
        columns: {
            identifier: [1, 'id'],
            editable: [[2, 'part_no'], [3, 'make_and_model', 'select', JSON.stringify({!!$hardwareStandardsArray!!})]]

            },
        warningClass: 'success',
        mutedClass: 'danger',
        restoreButton: false,
                onDraw: function(data) {
                },
        onSuccess: function(data) {
        if (data['status'] == 'error') {
            $('#error').show();
            $('#error .msg').text(data['message']);
            $('html, body').animate({
                scrollTop: $("#error").offset().top
            }, 1000);
        } else {
            $('#success .msg').text(data['message']);
            $('#success').show();
            $('#accessories-filter-form').submit();
        }
    },
    restoreButton: false
        });

    @endcan

    $('#accessories-mapping-table').DataTable(
        {
            responsive: true,
            scrollCollapse: false,
            scrollX: false,
            scrollY: false,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            columnDefs: [
                { "width": "2%", "targets": 0 },
                { "width": "49%", "targets": 1 },
                { "width": "49%", "targets": 2 },
                { orderable: false, targets: [4] },
            ],
            "order": [[2, "asc"]],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,
        }
    );

    });

    var delay = (function () {
        var timer = 0;
        return function (callback, ms) {
            clearTimeout(timer);
            timer = setTimeout(callback, ms);
        };
    })();

    $("#searchText").on('keyup change', function () {
        delay(function () {
            $('#accessories-filter-form').submit();
        }, 200);
    });

</script>