<div class="ibox">
	<div class="ibox-title">
		<div class="ibox-tools">
    <h5>Filters</h5>
    <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
</div>
	</div>

	<div class="collapse in" id="collapseFilter">
		<div class="ibox-content">
			<form method="post" id="insight-filter-form" action="{{ route('insight-mapping-search') }}">
				<div class="row">
					<div class="col-md-4">
						<div class="form-group">
							<label class="control-label">Hardware Standard</label>
							<select class="chosen-select" multiple id="make_and_model" name="make_and_model[]"
								data-placeholder="Select">
								@foreach(Facades\App\Repositories\HardwareStandards::getHardwareStandardsList() as $hardware)
								<option value="{{$hardware->id}}">{{$hardware->makeAndModel}}</option>
								@endforeach
							</select>
						</div>
					</div>

					<div class="col-md-4">
						<div class="form-group">
							<label class="control-label">Tech Specs</label>
							<select class="chosen-select technical_spec" multiple id="technical_spec"
								name="technical_spec[]" data-placeholder="Select">
								@foreach(\App\Models\TechnicalSpecs::orderBy('details')->get() as $technicalSpec)
								<option value="{{$technicalSpec->id}}">{{ $technicalSpec->details}}</option>
								@endforeach
							</select>
						</div>
					</div>

					<div class="col-md-4 divHeight">
						<div class="form-group">
							<label class="control-label">Search</label>
							<input type="text" class="form-control" name="searchText" id="searchText"
								placeholder="Search by Manufacturer Part" autocomplete="off">
						</div>
					</div>


				</div>
			</form>
		</div>
	</div>
</div>