@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'ASN - Insight', 'parentUrl' => '#', 'parentTitle' => 'Insight'])
@include('asn.insight.insight-submenu')

<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">

                @include('partials.success')
                @include('partials.error-list')
                @include('partials.sync-messages')
                <div id="insightErrorDeatil"></div>

                <div class="ibox">
                    @include('asn.insight.partials.filter.filter-insight-receive-assets')
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12" id="receive-insight-ibox">
                <div class="ibox">
                    <div class="ibox-title">
                        <div class="row">
                            <div class="col-md-3 form-group">
                                <label>Receive to Location:</label>
                                <select class="filter-field-location form-control" name="location_id" id="location_id"
                                    key="room_name" data-placeholder="Select">
                                </select>
                            </div>

                            <div class="col-md-3 form-group">
                                <label>Ticket #:</label>
                                <input type="text" class="form-control" name="ticket" id="ticket" placeholder="Ticket#"
                                    autocomplete="off" required="">
                            </div>

                            <div class="col-md-2"><br>
                                <button id="markReceived" class="btn btn-primary">Mark as received</button>

                            </div>

                            <div class="col-md-4 text-right button-group"><br>

                                <a href="#" id="manual-sync" class="btn btn-primary">Manual
                                    Sync</a>
                                <a href="#" id="export-insight-asset-csv" class="btn btn-primary">Export to CSV</a>
                            </div>
                        </div>
                    </div>

                    <div class="ibox-content">

                        @include('settings.partials.delete-message')

                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <div id="table-scroll">
                            <div class="table-wrap" style="overflow: auto; width: 100%">
                                <table
                                    class="footable table table-stripped table-hover nowrap"
                                    data-paging="true" data-paging-size="50" data-filter=#filter id="insight-table">

                                    <thead>

                                        <tr>

                                            <th>#</th>

                                            <th> <input type="checkbox" name="checkedAll" id="checkedAll"
                                                    title="Select All" /></th>

                                            <th>Asset Tag # (Insight)</th>

                                            <th>Serial # (Insight)</th>

                                            <th>PO # (Insight)</th>

                                            <th>Asset Type (Teqtivity)</th>

                                            <th>Manufacturer Part # (Insight)</th>

                                            <th>Hardware Standard (Teqtivity)</th>

                                            <th>Tech Specs (Teqtivity)</th>

                                            <th>Tracking Number (Insight)</th>

                                            <th>Shipment Status (Insight)</th>

                                            <th></th>

                                        </tr>

                                    </thead>

                                    <tbody>

                                    </tbody>


                                </table>
                            </div>
                        </div>

                    </div>

                </div>

            </div>
        </div>
    </div>
</div>

@include('asn.insight.partials.modal.insight-edit-modal')
@include('asn.insight.partials.modal.insight-delete-modal')
@include('asn.insight.partials.modal.insight-hardware-mapping-modal')
@include('asn.insight.partials.modal.insight-receive-modal')

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.vendor_integration'),'helpTitle'=>config('help-links.help_titles.vendor_integration')])
@endsection

@section('after_scripts')
@include('asn.insight.partials.script.insight-scripts')
@include('asn.insight.partials.script.insight-single-asset-receive-scripts')
@include('assets.partials.scripts.dropdown-script')


@stop