@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'ASN Bulk Upload'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
        <div class="col-lg-3">
                @include('toolbox.partials.side-nav')
            </div>
            <div class="col-lg-9">
                <div class="ibox">
                    <div class="ibox-content">                    
                        <h2>Bulk Upload</h2>
                        <div class="form-container">
                            <div class="message-div"></div>  
                            <form class="file-drag form-horizontal m-b-md dropzone"  action="/insight-bulk-upload/upload" method="post" id="dropzoneForm" enctype="multipart/form-data" id="dropzoneForm">
                                {{csrf_field()}}

                                <div class="fallback">
                                    <input name="file" type="file"/>
                                </div>                            
                            </form>
                       
                            @include('partials.success')
                            @include('partials.error-message')

                                <a href="/template/asn-bulk-upload-template.csv" class="pull-right-sm">Download Template File</a>
                                        
                            <h5>Assets (<span id="asset_count"></span>) </h5>
                            <form method="post" action="{{route('insight-bulk-upload.store')}}">
                                {{csrf_field()}}
                                <table id="tblview" class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter>
                                    <thead>
                                        <tr>
                                            <th>Customer PO #</th>
                                            <th>Manufacturer Name</th>
                                            <th>Manufacturer Part #</th>
                                            <th>Serial #</th>
                                            <th>Tracking #</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="5">
                                                <ul class="pagination pull-right"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                                <p class="text-right">
                                    <button type="submit" name="commit" class="btn btn-primary bulk-upload-save-button" disabled>Save</button>
                                </p>
                            </form>                        
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('after_scripts')
@include('settings.partials.file-drag-drop-script')
@stop