@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Insight Accessories Mapping', 'parentUrl' => '#', 'parentTitle'
=> 'Insight'])
@include('asn.insight.insight-submenu')


<div class="wrapper-content">
    <div class="container-fluid">
        @include('partials.success')
        @include('partials.error-list')
        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <h5>Bulk Upload</h5>
                    <a data-toggle="collapse" href="#collapseBulkUpload" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
                </div>
            </div>
            <div class="collapse in" id="collapseBulkUpload">
                <div class="ibox-content">
                    
                    <form class="form-horizontal" action="/insight-accessories-mapping/bulk-upload"
                    method="post" enctype="multipart/form-data">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="form-control" data-trigger="fileinput">
                                    <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                    <span class="fileinput-filename"></span>
                                </div>
                                <span class="input-group-addon btn btn-primary btn-file">
                                    <span class="fileinput-new">Select file</span>
                                    <span class="fileinput-exists">Change</span>
                                    <input type="file" name="bulk_upload_insight_accessories_mapping"
                                    id="bulk_upload_insight_accessories_mapping" required />
                                </span>
                                <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                data-dismiss="fileinput">Remove</a>
                            </div>
                            <a href="template/asn-accessories-mapping-template.csv"
                            class="pull-right">Download Template File</a>
                        </div>
                        <div class="col-lg-4">
                            <input type="submit" class="btn btn-primary" value="Save">
                            
                            
                        </div>
                        
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    @include('asn.insight.partials.filter.filter-insight-accessories-mapping')
    <div class="ibox">
        
        <div class="ibox-content">
            @can('Hardware Standards & Technical Specs Edit')
            <div class="row">
                <div class="col-md-12">
                    <p class="text-left">
                        <a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                        data-target="#addAccessoriesMapping">Add New</a>
                        
                        <a class="btn btn-primary"
                        href="{{route('insight.accessories.resync')}}">Resync
                        Mapping</a>
                    </p>
                </div>
            </div>
            @endcan
            @include('settings.partials.delete-message')
            @include('settings.partials.success-message')
            <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
            
            <table class="footable table table-stripped table-hover"
            data-paging="true" data-paging-size="50" data-filter=#filter
            id="accessories-mapping-table">
            
            <thead>
                
                <tr>
                    
                    <th width="15%">#</th>
                    
                    <th style="display: none;" data-visible="false">ID</th>
                    
                    <th width="40%">Manufacturer Part # (Insight)</th>
                    
                    <th width="40%">Accessory</th>
                </tr>
                
            </thead>
            
            <tbody>
                
                @include('asn.insight.partials.data.insight-accessories-mapping-data')
                
            </tbody>
            
            <tfoot>
                
                <tr colspan="5"></tr>
                
            </tfoot>
            
        </table>
        
    </div>
    
</div>

</div>

</div>


@include('asn.insight.partials.modal.insight-accessories-mapping-modal')
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.vendor_accessories_mapping'),'helpTitle'=>config('help-links.help_titles.vendor_accessories_mapping')])
@endsection

@section('after_scripts')
@include('asn.insight.partials.script.insight-accessories-mapping-scripts')
@stop