<script>
    $(document).ready(function () {
        $('body').on('click', '.recieve-asn-asset', function () {
            $('#receive-asset-form #modal_asset_id').val($(this).data('asset'));
        });
        $('.assigned-user-ajax').each(function () {
            allowClear: true,
                $(this).ajaxChosen({
                    dataType: 'json',
                }, {
                    processItems: function (data) {
                        return data
                    },
                    generateUrl: function (q) {
                        return '/get-filter-fields-assigned-user?search=' + q;
                    },
                }, {
                    width: "100%"
                }).change(function () {
                    if ($(this).val() != '') {
                        $("#modal_location_id").val('');
                        $('#modal_location_id_chosen .chosen-single').css('border', '1px solid #e5e6e7');
                        $('#modal_location_id_chosen .chosen-single span').html('Select an Option');
                    }
                    $(this).closest('.form-group').next().find('input').focus();
                });
        });


        $(".add_make_and_model").change(function () {
            $.ajax({
                type: "POST",
                data: { id: $(this).val() },
                url: "/assets-filter/listtechnics",
                success: function (data) {
                    $('.add_technical_spec').empty().trigger('chosen:updated');

                    $.each(data, function (key, value) {
                        $('.add_technical_spec').append($('<option>', {
                            value: value.id,
                            text: value.details
                        })).trigger('chosen:updated');
                    })

                }
            });
        });


        $("#modal_location_id").change(function () {
            if ($(this).val() != '') {
                $('#modal_user_id_chosen .chosen-single').css('border', '1px solid #e5e6e7');
                $('.assigned-user-ajax').val(null).trigger('change');
                $('#modal_user_id_chosen .chosen-single span').html('Select an Option');
            }
        });

        $("#receive-asset-form").submit(function (e) {
            e.preventDefault();
            $('.chosen-single.chosen-default').css('border', '1px solid #e5e6e7');
        }).validate({
            rules: {
                // ticket_no: {
                //     required: true,
                // },
                location_id: {
                    required: function (element) {
                        return $("#modal_user_id").val() == '';
                    }
                },
                user_id: {
                    required: function (element) {
                        return $("#modal_location_id").val() == '';
                    }
                }
            },
            messages: {
                location_id: {
                    required: "Select User or Location",
                },
                ticket_no: {
                    required: "Please Add a Ticket",
                },
                user_id: {
                    required: "Please Select a User",
                },
            },
            errorPlacement: function (error, element) {
                if (element.is('select')) {
                    error.appendTo($('#error_message'));
                    $('.chosen-single.chosen-default').css('border', '1px dotted #cc5965');
                } else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                markSingleItemReceived();
            }
        });

        function markSingleItemReceived() {
            $('.ajax-loader').show();
            var formData = $('#receive-asset-form').serialize();
            $(".sync-msg").hide();
            $(".sync-msg p").text('');

            $.ajax({
                type: 'POST',
                url: "{{ url('/receive-connection-asset/single-item-receive') }}",
                data: formData,

                success: function (data) {
                    $('#receiveAssetModal').modal('hide');
                    $('#receive-asset-form')[0].reset();
                    $('.assigned-user-ajax').val(null).trigger('change');
                    $('.chosen-single span').html('Select an Option');
                    // console.log(data.status);
                    if (data.status != 'Success') {
                        $('#error').show();
                        $('#error p').text(data.message);
                        $('html, body').animate({
                            scrollTop: $("#error").offset().top
                        }, 3000);
                    } else {
                        $("#sync-success-msg").html(data.message);
                        $("#sync-success").show();
                        $('html, body').animate({
                            scrollTop: $("#error").offset().top
                        }, 1000);
                    }
                    $('#connection-filter-form').submit();
                    $('.ajax-loader').hide();
                },
                error: function (data) { }
            });
        }
    });
</script>