<div class="ibox">
	<div class="ibox-title">
		<div class="ibox-tools">
    <h5>Filters</h5>
    <a data-toggle="collapse" href="#collapseFilter" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
</div>
	</div>

	<div class="collapse in" id="collapseFilter">
		<div class="ibox-content">
			<form method="post" id="connection-filter-form" action="{{ route('connection-mapping-search') }}">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label class="control-label">Hardware Standard</label>
							<select class="chosen-select" multiple id="make_and_model" name="make_and_model[]"
								data-placeholder="Select">
								@foreach(Facades\App\Repositories\HardwareStandards::getHardwareStandardsList() as $hardware)
								<option value="{{$hardware->id}}">{{$hardware->makeAndModel}}</option>
								@endforeach
							</select>
						</div>
					</div>

					<div class="col-md-6">
						<div class="form-group">
							<label class="control-label">Tech Specs</label>
							<select class="chosen-select" multiple id="technical_spec" name="technical_spec[]"
								data-placeholder="Select">
								@foreach(\App\Models\TechnicalSpecs::orderBy('details')->get() as $technicalSpec)
								<option value="{{$technicalSpec->id}}">{{ $technicalSpec->details}}</option>
								@endforeach
							</select>
						</div>
					</div>

					<div class="col-md-6 divHeight">
						<div class="form-group">
							<label class="control-label">Search</label>
							<input type="text" class="form-control" name="searchText" id="searchText"
								placeholder="Search by Description" autocomplete="off">
						</div>
					</div>


				</div>
			</form>
		</div>
	</div>

</div>