@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'Filtered Out Part #s', 'parentUrl' => '#', 'parentTitle' =>
'Connection'])
@include('asn.connection.connection-submenu')

<div class="wrapper-content">
    <div class="container-fluid">
        @include('partials.success')
        @include('partials.error-list')
        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <h5>Bulk Upload</h5>
                    <a data-toggle="collapse" href="#collapseBulkUpload" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
                </div>
            </div>
            <div class="collapse in" id="collapseBulkUpload">
                <div class="ibox-content">
                    
                    <form class="form-horizontal" action="/connection-unwanted-parts/bulk-upload"
                    method="post" enctype="multipart/form-data">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="form-control" data-trigger="fileinput">
                                    <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                    <span class="fileinput-filename"></span>
                                </div>
                                <span class="input-group-addon btn btn-primary btn-file">
                                    <span class="fileinput-new">Select file</span>
                                    <span class="fileinput-exists">Change</span>
                                    <input type="file" name="unwanted-parts-bulk-upload"
                                    id="bulk_upload_connection-accessories-mapping" required />
                                </span>
                                <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                data-dismiss="fileinput">Remove</a>
                            </div>
                            <a href="template/asn-unwanted-parts-template.csv" class="pull-right">Download
                                Template File</a>
                        </div>
                        <div class="col-lg-4">
                            <input type="submit" class="btn btn-primary" value="Save">
                            </div>
                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        
        @include('asn.connection.partials.filter.filter-connection-mappings')
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                    data-target="#addUnwantedParts">Add New</a>
                    <a class="btn btn-primary" href="{{route('connection.unwanted-parts.resync')}}">Sync
                        Part #s</a>
                    </p>
                    @include('settings.partials.delete-message')
                    @include('settings.partials.success-message')
                    <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                    <table
                    class="footable table table-stripped table-hover"
                    data-paging="true" data-paging-size="50" data-filter=#filter
                    id="unwanted-parts-table">
                    
                    <thead>
                        
                        <tr>
                            
                            <th>#</th>
                            
                            <th style="display: none;" data-visible="false">ID</th>
                            
                            <th>Manufacturer Part # (Connection)</th>
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                        
                        @include('asn.connection.partials.data.connection-unwanted-parts-data')
                        
                    </tbody>
                    
                    <tfoot>
                        <tr colspan="3"></tr>
                        
                        
                        
                    </tfoot>
                    
                </div>
                
            </div>
            
        </div>
        
    </div>
    
</div>
@include('asn.connection.partials.modals.connection-unwanted-parts-modal')

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.filter_out_part_numbers'),'helpTitle'=>config('help-links.help_titles.filter_out_part_numbers')])
@endsection

@section('after_scripts')

@include('asn.connection.partials.scripts.connection-unwanted-parts-scripts')
@stop