<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/hardware-filter.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<script>

    @if ($errors -> count() > 0)
        $("#addUnwantedParts").modal({ show: true });
    @endif

    $(document).ready(function () {

        $('.chosen-select').chosen({ width: "100%" });
        $('.make_model').chosen({ width: "100%" });

        $('#submit').click(function () {
            $('#unwanted-parts-form').submit();
        });


        $('#accessories-filter-form').submit(function (e) {

            e.preventDefault();
            $('.ajax-loader').show();
            var formData = $(this).serializeArray();

            $.ajax({
                type: "POST",
                url: "/cdw-unwanted-parts-search",
                data: formData,
                success: function (value) {

                    $('.ajax-loader').hide();

                    var dataTable = $("#unwanted-parts-table").DataTable();

                    // get the html table rows then
                    if ($.fn.DataTable.isDataTable('#unwanted-parts-table')) {
                        dataTable.clear();
                        dataTable.destroy();
                    }

                    $("tbody").empty().promise().done(function () {
                        $("tbody").html(value.hardware);
                    });

                    $('#unwanted-parts-table').Tabledit({
                        url: '/cdw-unwanted-parts-ajax',
                        columns: {
                            identifier: [1, 'id'],
                            editable: [[2, 'description']]
                        },
                        warningClass: 'success',
                        mutedClass: 'danger',
                        onDraw: function (data) {

                        },
                        onSuccess: function (data) {
                            $('.message-div').hide();

                            if (data.status == 'success') {
                                $('#success').show();
                                $('#success p').text(data.message);
                            }
                            else if (data.status == 'error') {
                                $('#error').show();
                                $('#error p').text("This mapping cannot be deleted .");
                            }
                            $('html, body').animate({
                                scrollTop: $("#error").offset().top
                            }, 1000);

                        },
                        onFail: function () {
                            $('#error').show();
                            $('#error p').text("Something went wrong. Please try again.");
                            $('html, body').animate({
                                scrollTop: $("#error").offset().top
                            }, 1000);
                        },
                        restoreButton: false
                    });
                },
                error: function (value) {

                }
            })
                .done(function () {
                    $('#unwanted-parts-table').DataTable(
                        {
                            responsive: true,
                            scrollCollapse: false,
                            scrollX: false,
                            scrollY: false,
                            lengthMenu: [
                                [50, 100, 200],
                                ['50', '100', '200']
                            ],
                            columnDefs: [
                                { "width": "10%", "targets": 0 },
                                { "width": "90%", "targets": 1 }
                            ],
                            fixedHeader: {
                                header: true,
                            },
                            "bFilter": false,
                            "bLengthChange": false,
                            "bInfo": false,
                        }
                    );
                });

        });


        @can('Hardware Standards & Technical Specs Edit')
        $('#unwanted-parts-table').Tabledit({
            url: '/cdw-unwanted-parts-ajax',
            columns: {
                identifier: [1, 'id'],
                editable: [[2, 'description']]
            },
            warningClass: 'success',
            mutedClass: 'danger',
            onDraw: function (data) {
            },
            onSuccess: function (data) {
                $('.message-div').hide();

                if (data.status == 'success') {
                    $('#success').show();
                    $('#success p').text(data.message);
                }
                else if (data.status == 'error') {
                    $('#error').show();
                    $('#error p').text("This mapping cannot be deleted .");
                }
                $('html, body').animate({
                    scrollTop: $("#error").offset().top
                }, 1000);

            },
            onFail: function () {
                $('#error').show();
                $('#error p').text("Something went wrong. Please try again.");
                $('html, body').animate({
                    scrollTop: $("#error").offset().top
                }, 1000);
            },
            restoreButton: false
        });

        @endcan

        $('#unwanted-parts-table').DataTable(
            {
                scrollCollapse: false,
                lengthMenu: [
                    [50, 100, 200],
                    ['50', '100', '200']
                ],
                fixedHeader: {
                    header: true,
                },
                columnDefs: [
                    { "width": "2%", "targets": 0 },
                    { "width": "49%", "targets": 1 },
                    { "width": "49%", "targets": 2 },
                ],
                "bFilter": false,
                "bLengthChange": false,
                "bInfo": false,
            }
        );

    });

    var delay = (function () {
        var timer = 0;
        return function (callback, ms) {
            clearTimeout(timer);
            timer = setTimeout(callback, ms);
        };
    })();

    $("#searchText").on('keyup change', function () {
        delay(function () {
            $('#accessories-filter-form').submit();
        }, 200);
    });

</script>