@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'CDW Assets Mapping', 'parentUrl' => '#', 'parentTitle' => 'CDW'])
@include('asn.cdw.cdw-submenu')

<div class="wrapper-content">
    <div class="container-fluid">
        @include('partials.success')
        @include('partials.error-list')
        <div class="ibox">
            <div class="ibox-title">
                <div class="ibox-tools">
                    <h5>Bulk Upload</h5>
                    <a data-toggle="collapse" href="#collapseBulkUpload" class="collapse-link"> <i class="icon icon-e-delete"></i></a>
                </div>
            </div>
            <div class="collapse in" id="collapseBulkUpload">
                <div class="ibox-content">
                    
                    <form class="form-horizontal" action="/cdw-hardware-mapping/bulk-upload"
                    method="post" enctype="multipart/form-data">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="form-control" data-trigger="fileinput">
                                    <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                    <span class="fileinput-filename"></span>
                                </div>
                                <span class="input-group-addon btn btn-primary btn-file">
                                    <span class="fileinput-new">Select file</span>
                                    <span class="fileinput-exists">Change</span>
                                    <input type="file" name="bulk_upload_cdw-hardware-mapping"
                                    id="bulk_upload_cdw-hardware-mapping" required />
                                </span>
                                <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                data-dismiss="fileinput">Remove</a>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <input type="submit" class="btn btn-primary" value="Save">
                            
                            <a href="template/asn-hardware-mapping-template.csv" class="pull-right">Download
                                Template File</a>
                            </div>
                            
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        @include('asn.cdw.partials.filter.cdw-hardware-mapping-filter')
        <div class="ibox">
            <div class="ibox-content">
                
                @can('Hardware Standards & Technical Specs Edit')
                <p>
                    <a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                    data-target="#addAsnMapping">Add New</a>
                    <a class="btn btn-primary" href="{{route('cdw.resync')}}">Resync Mapping</a>
                </p>
                @endcan
                
                @include('settings.partials.delete-message')
                @include('settings.partials.success-message')
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                
                <table class="footable collaptable table table-stripped table-hover" data-paging="true"
                data-paging-size="50" data-filter=#filter id="cdw-mapping-table">
                
                <thead>
                    
                    <tr>
                        
                        <th>#</th>
                        
                        <th style="display: none;" data-visible="false">ID</th>
                        
                        <th>Manufacturer Part # (CDW)</th>
                        
                        <th>Asset Type</th>
                        
                        <th style="width: 64px !important;">Manufacturer</th>
                        
                        <th>Hardware Standard</th>
                        
                        <th>Tech Specs</th>
                        
                    </tr>
                    
                </thead>
                
                <tbody>
                    
                    @include('asn.cdw.partials.data.cdw-hardware-mapping-data')
                    
                </tbody>
                
                <tfoot>
                    <tr colspan="6"></tr>
                </tfoot>
                
            </table>
            
        </div>
        
    </div>
    
</div>

</div>
@include('asn.cdw.partials.modal.cdw-hardware-mapping-modal')

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.vendor_asset_mapping'),'helpTitle'=>config('help-links.help_titles.vendor_asset_mapping')])
@endsection

@section('after_scripts')
@include('asn.cdw.partials.script.cdw-hardware-mapping-scripts')
@stop