@extends('layouts.main')
@section('content')

@include('partials.breadcrumb', ['breadcrumbTitle' => 'ASN - '.config("asn.name"), 'parentUrl' => '#', 'parentTitle'
=> config("asn.name")])
@include('asn.partials.submenu')
<div class="wrapper-content">
    <div class="container-fluid ">
        <div class="row">

            @include('partials.success')
            @include('partials.error-list')
            @include('partials.sync-messages')
            <div id="asnErrorDeatil"></div>
            <div class="ibox">
                @include('asn.partials.filter-asn-assets')
            </div>
        </div>
        <div class="row">

            <div class="col-lg-12" id="receive-cdw-ibox">
                <div class="ibox">



                    <div class="ibox-title col-lg-12" style="padding-bottom: 15px;">
                        <div class="col-lg-10" style="padding: 0px">
                            <div class="col-lg-2" style="padding: 0px">
                                <button id="selectAll" class="btn btn-primary selectAll"
                                    onclick="selectAll()">Select All</button>

                            </div>

                            <div class="col-lg-2" style="width: 14%;padding: 0px;margin-top: 8px;">
                                <label>Receive to Location:</label>
                            </div>

                            <div class="col-lg-4" style="padding: 0px">
                                @include('partials.dropdowns.location-warehouse-valid')
                            </div>
                            <div class="col-lg-2">
                                <input type="text" class="form-control" name="ticket" id="ticket" placeholder="Ticket#"
                                    autocomplete="off" required="">
                            </div>
                            <div class="col-lg-2" style="padding: 0px">
                                <button id="markReceived" class="btn btn-primary">Mark as received</button>

                            </div>
                        </div>
                        <div class="col-lg-1">
                            <a href="javascript:void(0)" id="manual-sync" class="btn btn-primary"
                                style="margin-left: -70px;">Manual
                                Sync</a>
                            <a href="javascript:void(0)" id="manual-sync-load" class="btn btn-primary"
                                style="margin-left: -70px;display:none;"><i
                                    class="icon icon-explore-user"></i></a>
                        </div>
                        <div class="col-lg-1"><a href="#" id="export-asn-asset" class="btn btn-info"
                                style="margin-left: -45px;">Export to CSV</a></div>
                    </div>
                    <div class="ibox-content">

                        @include('settings.partials.delete-message')
                        @include('settings.partials.success')


                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <table class="footable collaptable table table-stripped table-hover" data-paging="true"
                            data-paging-size="50" data-filter=#filter id="receive-asn-assets-table"
                            style="z-index: 99999">
                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th> </th>

                                    <th>Asset Tag # ({{ Config::get('asn.name') }})</th>

                                    <th>Serial # ({{ Config::get('asn.name') }})</th>

                                    <th>PO # ({{ Config::get('asn.name') }})</th>

                                    <th>Asset Type (Teqtivity)</th>

                                    <th>Manufacturer Part # ({{ Config::get('asn.name') }})</th>

                                    <th>Hardware Standard (Teqtivity)</th>

                                    <th>Tech Specs (Teqtivity)</th>

                                    <th>Tracking Number ({{ Config::get('asn.name') }})</th>

                                    <th>Shipment Status</th>

                                    <th style="width:78px">Action</th>

                                </tr>

                            </thead>

                            <tbody>


                            </tbody>

                            <tfoot>
                                <tr colspan="12"></tr>

                            </tfoot>

                        </table>
                    </div>

                </div>


            </div>

        </div>

    </div>

    @include('asn.modals.edit-modal')
    @include('asn.modals.delete-modal')
    @include('asn.modals.asn-hardware-mapping-modal')
    @include('asn.modals.receive-modal')

    @stop

    @section('after_scripts')
    @include('asn.scripts.asn-scripts')
    @include('asn.scripts.hardware-mapping-scripts')

    @stop