@extends('layouts.auth')
@section('content')                    
<h2>Sign In</h2>

<form role="form" action="{{route('admin-login')}}" method="post" autocomplete="off">
    {{csrf_field()}}
    @if (count($errors) > 0)
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger alert-dismissible" role="alert">
        <strong>{{$error}}</strong>
    </div>
    @endforeach
    @endif
    
    <div class="form-group">
        
        <input type="email" name="email" class="form-control" placeholder="Username" required="" value="{{old('email')}}">
        
    </div>
    
    <div class="form-group">
        <input type="password" name="password" class="form-control" id="password1" placeholder="Password" value="">             
    </div>
    
    <button type="submit" class="btn btn-primary btn-block">Login</button>
    
</form>

@endsection