@forelse($accessories as $accessory)
<tr>
	<td>{{$loop->iteration}}</td>
	@if($accessory->available_quantity == 0)
	<td colspan="2">
		@can('Accessories Edit')
		<form id="{{$accessory->id}}" action="{{ route('accessories.destroy', $accessory->id) }}" method="POST">		    
			<input type="hidden" name="_method" value="DELETE">
		    <input type="hidden" name="_token" value="{{ csrf_token() }}">
		    
		    <input type="button" id="btndelete" value="Delete" class="btndelete btn btn-block btn-danger btn-sm" >

		    <input type="hidden" id="hardware_standard" value="{{optional($accessory->makeAndModel)->makeModelName or ''}}">


		</form>
		@endcan
	</td>
	@endif 

	@if($accessory->available_quantity != 0)
	<td>
		
		@can('Accessories Edit')
		<a href="" data-action="{{route('accessories.update', ['accessory' => $accessory->id])}}"  class="btn btn-primary btn-sm accessoriesModal" data-post-id="{{$accessory->id}}" data-post-quantity="{{$accessory->available_quantity}}" data-toggle="modal" data-target="#moveModal">Transfer</a>
		@endcan
	</td>
	@endif 
	
	@if($accessory->available_quantity != 0)
	<td>
		
		@can('Accessories Edit')
		<a href="" data-action="{{route('accessories.update', ['accessory' => $accessory->id])}}" class="btn btn-primary btn-sm"  data-toggle="modal" data-post-id="{{$accessory->id}}" data-post-quantity="{{$accessory->available_quantity}}" data-target="#consumeModal">Consume</a>
		@endcan
	</td>
	@endif 
	
	<td>
		
		@can('Accessories Edit')
		<a href="" data-action="{{route('accessories.update', ['accessory' => $accessory->id])}}" class="btn btn-primary btn-sm"  data-toggle="modal" data-post-id="{{$accessory->id}}" data-target="#addModal">Add</a>
		@endcan
	</td>

	<td>{{$accessory->location->room_name ?? ''}}</td>

	<td>{{$accessory->makeAndModel->makeModelName ?? ''}}</td>

	<td>{{$accessory->available_quantity}}</td>

	<td><input onblur="updateQuantity('min', {{$accessory->id}}, this)" type="number" class="form-control" value="{{$accessory->min}}" @can('Accessories Edit') @else readonly @endcan> </td>

	<td><input onblur="updateQuantity('max', {{$accessory->id}}, this)" type="number" class="form-control" value="{{$accessory->max}}" @can('Accessories Edit') @else readonly @endcan> </td>
	
	<td><input onblur="updateQuantity('weekly_demand', {{$accessory->id}}, this)" type="number" class="form-control" value="{{$accessory->weekly_demand}}" @can('Accessories Edit') @else readonly @endcan></td>

	
	<td><input onblur="updateQuantity('lead_time', {{$accessory->id}}, this)" type="number" class="form-control" value="{{$accessory->lead_time}}" @can('Accessories Edit') @else readonly @endcan></td>

	<td id="order-qty-{{$accessory->id}}">{{$accessory->order_quantity}}</td>

	<td id="purchase-indicator-{{$accessory->id}}">{{$accessory->purchase_indicator ? 'Yes' : 'No'}}</td>
</tr>
@empty
<tr>
	<td colspan="11" align="right">No accessories found.</td>
</tr>
@endforelse
@if(isset($purchaseIndicator) && $purchaseIndicator[0] == 1)
<tr>
	<td colspan="12" align="right"><a class="btn btn-primary" href="{{route('download', ['file' => $purchaseFile])}}" style="text-decoration: none; color:#fff">Purchase</a></td>
</tr>
@endif
