@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Accessories'])

<div class="wrapper-content">

	<div class="container-fluid">

		@include('partials.success')
		@include('partials.error-message')
		@include('settings.partials.success-message')
		@include('settings.partials.delete-message')
		<div id="saved-search-success"></div>

		@include('reports.partials.saved-searchs')
		@include('accessories.partials.filter')

		<div class="row">

			<div class="col-lg-12">

				<div class="ibox">

					<div class="ibox-content">

						@can('Accessories Edit')
						<p><a href="" class="btn btn-primary" data-toggle="modal" data-target="#createModal">Create</a></p>
						@endcan



						<table class="footable table table-stripped table-hover set-min-width-input" data-page-size="50"
							data-filter=#filter>

							<thead>

								<tr>

									<th>#</th>

									<th>Action</th>

									<th></th>

									<th></th>

									<th>Inventory Location</th>

									<th>Hardware Standard</th>

									<th>Available Quantity</th>

									<th>Weekly Demand</th>

									<th>Lead Time (weeks)</th>

									<th>Order Qty (for 6 weeks)</th>

									<th>Purchase Indicator</th>

								</tr>

							</thead>

							<tbody>



							</tbody>

						</table>



					</div>

				</div>

			</div>

		</div>

	</div>

	@include('accessories.modals.create')
	@include('accessories.modals.move')
	@include('accessories.modals.use')
	@include('accessories.modals.add')
	@include('accessories.modals.confirm-delete')

	@stop 

	@section('help-links')
	@include('help.help-links',['helpLink'=>config('help-links.help_links.accessories'),'helpTitle'=>config('help-links.help_titles.accessories')])
	@endsection

	@section('after_scripts')
	@include('accessories.partials.scripts.script')
	@stop
