$.validator.addMethod("exists", function(value, element) {
	var result = false;
    $.ajax({
        type:"POST",
        dataType: 'json',
        async: false,
        url: "/assets/check-exists", // script to validate in server side
        data: {value: value, name: element.name},
        success: function(data) {
            result = (data == true) ? true : false;
        }
    });
    return result;
}, 'This value doesn\'t exist');

$.validator.addMethod("unique", function(value, element) {
    var result = false;
    $.ajax({
        type:"POST",
        dataType: 'json',
        async: false,
        url: "/assets/check-unique", // script to validate in server side
        data: {value: value, name: element.name},
        success: function(data) {
            result = (data == true) ? true : false;
        }
    });
    return result;
}, 'This value already exists');



$.validator.addMethod("clientunique", function(value, element) {
    var result = true;

   try{
     $('#tblview tbody tr td:nth-child(4)').each(function() {
               if($("#asset_tag").val().trim()!=''){
                    if($("#asset_tag").val().trim()==$(this).html().trim()){
                        result=false;
                    }
               }

      });
    }
    catch(err){
        console.error("Error occurred in validation method: ", err);
    }

    return result;
}, 'This value already exists');


$.validator.addMethod("imeiunique", function(value, element) {
    var result = true;

   try{
     $('#tblview tbody tr td:nth-child(5)').each(function() {
               if($("#imei").val().trim()!=''){
                    if($("#imei").val().trim()==$(this).html().trim()){
                        result=false;
                    }
               }

      });
    }
    catch(err){
        console.error("Error occurred in validation method: ", err);
    }

    return result;
}, 'This value already exists');

$.validator.addMethod("serialunique", function(value, element, index) {
    var result = true;

   try{
     $('#tblview tbody tr td:nth-child('+index+')').each(function() {
               if($("#serial_no").val().trim()!=''){
                    if($("#serial_no").val().trim()==$(this).html().trim()){
                        result=false;
                    }
               }

      });
    }
    catch(err){
        console.error("Error occurred in validation method: ", err);
    }

    return result;
}, 'This value already exists');

$.validator.addMethod("addedUnique", function(value, element, index) {
    var result = true;

   try{
        var $tds = $('.table-striped tbody tr td:nth-child('+index+')').filter(function () {
            return $.trim($(this).text()) == value;
        });
        if ($tds.length != 0) {
            result = false;
        }
    }
    catch(err){
        console.error("Error occurred in validation method: ", err);
    }

    return result;
}, 'This value already exists');

$.validator.addMethod("parent", function(value, element) {
    var result = false;
    $.ajax({
        type:"POST",
        dataType: 'json',
        async: false,
        url: "/assets/check-parent", // script to validate in server side
        data: {value: value, name: element.name, type:$("#category").val()},
        success: function(data) {
            result = (data == true) ? true : false;
        }
    });
    return result;
}, 'This asset is not a parent');

$.validator.addMethod("child", function(value, element) {
    var result = false;
    $.ajax({
        type:"POST",
        dataType: 'json',
        async: false,
        url: "/assets/check-child", // script to validate in server side
        data: {value: value, name: element.name, type:$("#category").val()},
        success: function(data) {
            result = (data == true) ? true : false;
        }
    });
    return result;
}, 'This asset is not a child');

$.validator.addMethod("canBeMoved", function(value, element) {
    var result = false;
    var errorMessage = 'You are attempting to move a child asset or an asset that must be returned to a location first'; // Default error message

    // Get the form that is currently being validated
    var form = $(element).closest('form');

    // Get the values from the specific form
    var locationId = form.find("#location_id").val();
    var category = form.find("#category").val();

    // Perform the AJAX request
    $.ajax({
        type: "POST",
        dataType: 'json',
        async: false,
        url: '/validate/move',
        data: {
            asset_tag: value, // This is the value being validated (the asset tag)
            location_id: locationId, // The location_id from the current form
            type: category // The category from the current form
        },
        success: function(data) {
            if (data.status) {
                result = true; // The asset can be moved
            } else {
                result = false; // The asset cannot be moved
                errorMessage = data.message; // Set the server's message as the error message
            }
        },
        error: function() {
            result = false; // In case of an error, prevent the asset from being moved
        }
    });

    // Set the custom message for this validation rule
    $.validator.messages.canBeMoved = errorMessage;

    return result;
}, ''); // Leave the default error message empty as it will be dynamically set



$.validator.addMethod("canBeLinked", function(value, element) {
    var result = false; // Initialize result as false
    var errorMessage = 'This asset cannot be linked due to status restrictions'; // Default error message

    // Get the form that is currently being validated
    var form = $(element).closest('form');

    // Get the values from the specific form
    var childSerial = form.find("#child_serial_no").val();
    var category = form.find("#category").val();
    var parentSerial = form.find("#parent_serial_no").val();

    // AJAX request to validate the link
    $.ajax({
        type: "POST",
        dataType: 'json',
        async: false,
        url: '/validate/link',
        data: {
            asset_tag: value, 
            child_serial_no: childSerial,
            parent_serial_no: parentSerial, 
            type: category,
        },
        success: function(data) {
            if (data.status) {
                result = true;
            } else {
                result = false;
                errorMessage = data.message; // Use the message from the server
            }
        },
        error: function() {
            console.error("AJAX request failed.");
            result = false;
        }
    });

    // Set the custom message for this validation rule
    $.validator.messages.canBeLinked = errorMessage;

    return result;
}, '');


$.validator.addMethod("canBeReturned", function(value, element) {
    // Get the form that is currently being validated
    var form = $(element).closest('form');
    var category = form.find("#category").val();
    var toLocation = form.find("#location_id").val();

    var result = false; // Default to false
    var errorMessage = 'You are attempting to return an asset that is in your inventory'; // Default error message

    $.ajax({
        type: "POST",
        dataType: 'json',
        async: false,
        url: '/validate/return',
        data: { asset_tag: value, type: category, location_id: toLocation },
        success: function(data) {
            if (data.status) {
                result = true; // The asset can be returned
            } else {
                result = false; // The asset cannot be returned
                errorMessage = data.message; // Use the server's message
            }
        },
        error: function() {
            result = false; // If there's an error, prevent the asset from being returned
        }
    });

    // Set the custom message for this validation rule
    $.validator.messages.canBeReturned = errorMessage;

    return result;
}, '');


$.validator.addMethod("canBeUpdated", function(value, element) {
    $.ajax({
        type: "POST",
        dataType: 'json',
        async: false,
        url : '/validate/update',
        data: {asset_status_id: value, asset_tag: $('#serial_no').val()},
        success: function(data) {
            result = (data.status == true) ? true : false;
            message = 'Sorry, you cannot update the asset status from '+data.currentStatus+' to '+data.newStatus;
        }
    })
    if (result){
        return true;
    } else {
        $.validator.messages.canBeUpdated = message;
        return false;
    }
}, '');

$.validator.addMethod("checkAssetType", function(value, element) {
    $.ajax({
        type: "POST",
        dataType: 'json',
        async: false,
        url : '/validate/typecheck',
        data: {asset_tag: value, type:$("#category").val()},
        success: function(data) {
            result = (data == true) ? true : false;
        }
    })
    return result;
}, 'Not a valid asset ');

$.validator.addMethod("custome_required", function(value, element) {

    return (value == '--Select--' || value == '0' || value=='') ? false : true;
}, 'This field is required');

$.validator.addMethod("exist_in_jira", function(value, element) {
    $.ajax({
        type: "POST",
        dataType: 'json',
        async: false,
        url : '/validate/ticket-exist',
        data: {ticket_no: value},
        success: function(data) {
            result = (data == true) ? true : false;
        }
    })
    return result;
}, 'This ticket is not valid');

$.validator.addMethod("unique_fields", function(value, element, index) {
    var result = true;
    try{
        $('#tblview tbody tr td:nth-child('+index[0]+')').each(function() {
            if($("#"+index[1]).val().trim()!=''){
                if($("#"+index[1]).val().trim()==$(this).html().trim()){
                    result=false;
                }
            }

        });
    }

    catch(err){
        console.error("Error occurred in validation method: ", err);
    }

    return result;
}, 'This value already exists');

$.validator.addMethod("alphanumeric", function(value, element) {
	return this.optional(element) || /^\w+$/i.test(value);
}, "Letters, numbers, and underscores only please");

$.validator.addMethod("letterswithbasicpunc", function(value, element) {
	return this.optional(element) || /^[a-z\-.,()'"\s]+$/i.test(value);
}, "Letters or punctuation only please");

$.validator.addMethod("lkey_alphanumeric", function(value, element) {
	return this.optional(element) || /^[a-zA-Z0-9_,\r\n -]+$/i.test(value);
}, "Only letters, numbers, new line, underscores and hyphen are allowed");

$.validator.addMethod("lettersonly", function(value, element) {
	return this.optional(element) || /^[a-z]+$/i.test(value);
}, "Letters only please");


$.validator.addMethod("keylength", function(value, element,lengthArray=[6,20]) {
    var word = value.split(",");
    var keyLengths =[];
    $.each(word,function (key,val) {
        if(!val){
            return true;
        }
        if(val.length < lengthArray[0] || val.length > lengthArray[1] ){
            keyLengths.push(val.length);
        }

    });
    return $.isEmptyObject(keyLengths);
}, "Please enter keys of  6 to 20 characters in length");

jQuery.validator.addMethod("after_or_equal",
function(value, element, params) {
    if(!value || !$(params).val()){
        return true;
    }
    if (!/Invalid|NaN/.test(new Date(value))) {
        return new Date(value) >= new Date($(params).val());
    }

},'End date must be a date after or equal to start date.');


$.validator.addMethod( "no_whitespace", function( value, element ) {
	return this.optional( element ) || /^\S+$/i.test( value );
}, "No white space is allowed." );

$.validator.addMethod( "no_whitespaces", function( value, element ,exceptions) {
    if($.inArray($("#asset_type_id option:selected").text(), exceptions) !== -1){
        return true;
    }
	return this.optional( element ) || /^\S+$/i.test( value );
}, "No white space is allowed." );


/* It is used to check if an asset is in frozen location*/
$.validator.addMethod("checkFromLocationIsFreeze", function(value, element) {
    var result = false;
    $.ajax({
        type:"POST",
        dataType: 'json',
        async: false,
        url: "/validate/check-freeze-location", // script to validate in server side
        data: {value: value, name: element.name},
        success: function(data) {
            result = (data == true) ? true : false;
        }
    });
    return result;
}, 'Asset from freezed location cannot move to another location');


/* It is used to check if an asset has already been scanned in a cycle count process. */
$.validator.addMethod("checkIfAlreadyScanned", function(value, element) {
    var result = false;
    var formData = $("#varience-create-form").serializeObject();
    $.ajax({
        type: "POST",
        dataType: 'json',
        async: false,
        url: "/inventory-control/cycle-count/check-scanned-assets", // script to validate in server side
        data: formData,
        success: function(data) {
            result = (data == 'serial_exist') ? false : true;
        }
    });
    return result;
}, 'This asset is already scanned');
/*  to validate if the scanned asset  assettype matches the selected asset types. */
$.validator.addMethod("checkScannedAssetType", function(value, element) {
    var result = false;
    var formData = $("#varience-create-form").serializeObject();
    $.ajax({
        type: "POST",
        dataType: 'json',
        async: false,
        url: "/inventory-control/cycle-count/check-scanned-assetstype", // script to validate in server side
        data: formData,
        success: function(data) {
            result = (data == 'type_mismatch') ? false : true;
        }
    });
    return result;
}, 'Asset type mismatch');

$.validator.addMethod("enum", function(value, element, param) {
    return this.optional(element) || param.includes(value);
}, "Please enter a valid value.");


