/**
 * @description Inline editor for HTML tables compatible with Bootstrap
 * @version     1.2.3
 * @author      Celso Marques
 * @copyright   Copyright (c) 2015 Celso Marques
 * @link        https://github.com/markcell/jQuery-Tabledit
 */

/**
 * The modified version
 * @version     1.2.7
 * @author      Thomas Zukal
 * @copyright   Copyright (c) 2017 Thomas Zukal
 * @link        https://github.com/BluesatKV/jquery-tabledit
 *
 * REQUIRED USER OPTIONS
 * --------------------
 *
 *  columns: {
 *
 *    // Column used to identify table row.
 *    //
 *    //  column_index - index of column in table 0, 1, 2, 3 etc...
 *    //  input_name - name of column in your DB (MySQL)
 *    //
 *    // [column_index, input_name]
 *    identifier: [0, 'id'],
 *
 *    // Columns to transform in editable cells -> supported type "input", "hidden", "number", "date", "select", "textarea"
 *
 *    editable: [
 *
 *          // [[column_index, input_name, input_type_text]
 *          [1, 'col1', 'input'],
 *
 *          // [[column_index, input_name, input_type_hidden]
 *          [2, 'col2', 'hidden'],
 *
 *          // [[column_index, input_name, input_type_number]
 *          [3, 'col3', 'number'],
 *
 *          // [[column_index, input_name, input_type_date]
 *          [4, 'col4', 'date'],
 *
 *          // [[column_index, input_name, textarea_type, textarea_options] -> supported attributes "rows", "cols", "maxlength", "wrap"
 *          [5, 'col5', , 'textarea', '{"rows": "3", "cols": "10", "maxlength": "200", "wrap": "hard"}'],
 *
 *          [column_index, input_name, select_type, select_options]]
 *          [6, 'col6', 'select', '{"1": "Red", "2": "Green", "3": "Blue"}']
 *       ]
 *    }
 *
 */
if("undefined"==typeof jQuery)throw new Error("Tabledit requires jQuery library.");!function(t){"use strict";var e="_TableditData",n={init:function(n){function i(t){var e={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"","'":"","/":"&#x2F;","`":"&#x60;","=":"&#x3D;"};return String(t).replace(/[&<>"'`=\/]/g,function(t){return e[t]})}function a(e){function n(t){var e=null;if(document.cookie&&""!=document.cookie)for(var n=document.cookie.split(";"),i=0;i<n.length;i++){var a=jQuery.trim(n[i]);if(a.substring(0,t.length+1)==t+"="){e=decodeURIComponent(a.substring(t.length+1));break}}return e}function i(t){return/^(GET|HEAD|OPTIONS|TRACE)$/.test(t)}var a,l,u=s.find(".tabledit-input").serialize();return u?(u+="&action="+e,l=o.onAjax(e,u),l===!1?!1:(o.method=o[e+"method"],t.ajaxSetup({beforeSend:function(t,e){i(e.type)||this.crossDomain||t.setRequestHeader("X-CSRFToken",n("csrftoken"))}}),a=t.ajax({url:o.url,type:o.method,data:u,dataType:"json"}),a.done(function(t,n,i){"success"==n?(e===o.buttons.edit.action&&(d.removeClass(o.dangerClass).addClass(o.successClass),setTimeout(function(){s.find("tr."+o.successClass).removeClass(o.successClass)},1500)),o.onSuccess(t,n,i)):o.onFail(n)}),a.fail(function(t,n,i){e===o.buttons["delete"].action?(r.removeClass(o.mutedClass).addClass(o.dangerClass),r.find(".tabledit-toolbar button").attr("disabled",!1),r.find(".tabledit-toolbar .tabledit-restore-button").hide()):e===o.buttons.edit.action&&d.addClass(o.dangerClass),o.onFail(t,n,i),console.log("Tabledit Ajax fail => "+n+" : "+i)}),a.always(function(){o.onAlways()}),a)):!1}var s=this;if("table"!==s.prop("tagName").toLowerCase())throw new Error("Tabledit only works when applied to a table.");var l=function(t){return void 0!==t||null!==t||""!==t};if(!l(n.columns))return console.log("Tabledit Jquery Plugin not initialize. Set required parameters."),this;l(n.lang)&&n.lang in s.Tabledit.langs?n.lang=n.lang.toLowerCase():n.lang=s.Tabledit.defaults.lang;var o=t.extend({},s.Tabledit.defaults,n);t(this).data(e,t.extend({},s.Tabledit.defaults,n||{}));var d="undefined",r="undefined",u="undefined";if(o.editButton&&o.buttons.edit.html)var b=o.buttons.edit.html;else var b=s.Tabledit.langs[o.lang].btn_edit;if(o.deleteButton&&o.buttons["delete"].html)var c=o.buttons["delete"].html;else var c=s.Tabledit.langs[o.lang].btn_delete;if(o.confirmButton&&o.buttons.confirm.html)var f=o.buttons.confirm.html;else var f=s.Tabledit.langs[o.lang].btn_confirm;if(o.saveButton&&o.buttons.save.html)var p=o.buttons.save.html;else var p=s.Tabledit.langs[o.lang].btn_save;if(o.restoreButton&&o.buttons.restore.html)var h=o.buttons.restore.html;else var h=s.Tabledit.langs[o.lang].btn_restore;n.debug&&console.log("Tabledit Init -> Element:",s),n.debug&&console.log("Tabledit Init -> dataPrefix:",e),n.debug&&console.log("Tabledit Init -> Settings: ",o),n.debug&&console.log("Tabledit Init: -----------------------------------");var m={columns:{identifier:function(){o.hideIdentifier&&s.find("th:nth-child("+parseInt(o.columns.identifier[0])+"1), tbody td:nth-child("+parseInt(o.columns.identifier[0])+"1)").hide();var e=s.find('tbody tr:not(".'+o.noEditClass+'") td:not(".'+o.noEditClass+'")').filter(":nth-child("+(parseInt(o.columns.identifier[0])+1)+")");e.each(function(){var e=t.trim(t(this).text().replace(/^\s+|\s+$/g,"")),e=o.escapehtml?i(e):e,n='<span class="tabledit-span tabledit-identifier">'+e+"</span>",a='<input class="tabledit-input tabledit-identifier" type="hidden" name="'+o.columns.identifier[1]+'" value="'+e+'" disabled>';t(this).html(n+a),t(this).parent("tr").attr(o.rowIdentifier,t.trim(t(this).text()))})},editable:function(){for(var e=0;e<o.columns.editable.length;e++){var n=s.find('tbody tr:not(".'+o.noEditClass+'") td:not(".'+o.noEditClass+'")').filter(":nth-child("+(parseInt(o.columns.editable[e][0])+1)+")");n.each(function(){var n=t.trim(t(this).text().replace(/(^\s+|\s+$)/g,"")),n=o.escapehtml?i(n):n;o.editButton||t(this).css("cursor","pointer");var a,l='<span class="tabledit-span">'+n+"</span>",d=["input","hidden","number","date","select","textarea"],r=["rows","cols","maxlength","wrap"],u=o.columns.editable[e][2];switch(-1==t.inArray(u,d)&&(u="input"),u){case"input":a='<input class="tabledit-input '+o.inputClass+'" type="text" name="'+o.columns.editable[e][1]+'" value="'+n+'" style="display: none;" disabled>';break;case"hidden":a='<input class="tabledit-input '+o.inputClass+'" type="hidden" name="'+o.columns.editable[e][1]+'" value="'+n+'" style="display: none;" disabled>';break;case"number":a='<input class="tabledit-input '+o.inputClass+'" type="number" name="'+o.columns.editable[e][1]+'" value="'+n+'" style="display: none;" disabled>';break;case"date":a='<input class="tabledit-input '+o.inputClass+'" type="date" name="'+o.columns.editable[e][1]+'" value="'+n+'" style="display: none;" disabled>';break;case"select":"undefined"!=typeof o.columns.editable[e][3]&&(a='<select class="tabledit-input '+o.inputClass+'" name="'+o.columns.editable[e][1]+'" style="display: none;" disabled>',t.each(t.parseJSON(o.columns.editable[e][3]),function(e,i){i=t.trim(i),a+=n===i?'<option value="'+e+'" selected>'+i+"</option>":'<option value="'+e+'">'+i+"</option>"}),a+="</select>");break;case"textarea":var b;a="<textarea ","undefined"!=typeof o.columns.editable[e][3]?t.each(t.parseJSON(o.columns.editable[e][3]),function(e,n){a+=-1!=t.inArray(e,r)?e+'="'+n+'" ':"",b="maxlength"==e&&n.length>0?s.Tabledit.langs[o.lang].txt_allowchar.replace("%s",n)+' | <span class="countno_"></span> '+s.Tabledit.langs[o.lang].txt_remain:s.Tabledit.langs[o.lang].txt_nolimit}):b=s.Tabledit.langs[o.lang].txt_nolimit,a+=' class="tabledit-input '+o.inputClass+'" name="'+o.columns.editable[e][1]+'" style="display: none;" disabled>'+n+'</textarea><span class="count_" style="display: none;">'+b+"</span>"}t(this).html(l+a),t(this).addClass("tabledit-view-mode")})}},toolbar:function(){if(o.editButton||o.deleteButton){var t="",e="",n="",i="",a="";0===s.find("th.tabledit-toolbar-column").length&&s.find("tr:first").append('<th class="tabledit-toolbar-column '+o.toolbarHeaderClass+'">'+s.Tabledit.langs[o.lang].txt_action+"</th>"),o.editButton&&(t='<button type="button" class="tabledit-edit-button '+o.buttons.edit["class"]+'" style="float: none;">'+b+"</button>"),o.deleteButton&&(e='<button type="button" class="tabledit-delete-button '+o.buttons["delete"]["class"]+'" style="float: none;">'+c+"</button>",a='<button type="button" class="tabledit-confirm-button '+o.buttons.confirm["class"]+'" style="display: none; float: none;">'+f+"</button>"),o.editButton&&o.saveButton&&(n='<button type="button" class="tabledit-save-button '+o.buttons.save["class"]+'" style="display: none; float: none;">'+p+"</button>"),o.deleteButton&&o.restoreButton&&(i='<button type="button" class="tabledit-restore-button '+o.buttons.restore["class"]+'" style="display: none; float: none;">'+h+"</button>");var l='<div class="tabledit-toolbar '+o.toolbarClass+'" style="text-align: left;">\n                                           <div class="'+o.groupClass+'" style="float: none;">'+t+e+"</div>\n                                           "+n+"\n                                           "+a+"\n                                           "+i+"\n                                       </div></div>";s.find('tbody > tr:not(".'+o.noEditClass+'")').append('<td class="toolbar" style="white-space: nowrap; width: 1%;">'+l+"</td>"),s.find("tbody > tr."+o.noEditClass).append('<td class="toolbar" style="white-space: nowrap; width: 1%;"></td>')}}}},v={view:function(e){var n=t(e).parent("tr");t(e).parent("tr").find(".tabledit-input.tabledit-identifier").prop("disabled",!0),t(e).find(".tabledit-input").blur().hide().prop("disabled",!0),t(e).find(".count_").hide(),t(e).find(".tabledit-span").show(),t(e).addClass("tabledit-view-mode").removeClass("tabledit-edit-mode"),o.editButton&&(n.find("button.tabledit-save-button").hide(),n.find("button.tabledit-edit-button").removeClass("active").blur())},edit:function(e){y.reset(e);var n=t(e).parent("tr");n.find(".tabledit-input.tabledit-identifier").prop("disabled",!1),t(e).find(".tabledit-span").hide();var i=t(e).find(".tabledit-input");i.prop("disabled",!1).show(),t(e).find("textarea").css({resize:"none"}),t(e).find(".count_").css({color:"#CCC",display:"block","float":"right"}).show(),t(e).find(".countno_").html("..."),o.autoFocus&&i.focus(),t(e).addClass("tabledit-edit-mode").removeClass("tabledit-view-mode"),o.editButton&&(n.find("button.tabledit-edit-button").addClass("active"),n.find("button.tabledit-save-button").show())}},g={reset:function(e){t(e).each(function(){var e=t(this).find(".tabledit-input"),n=t.trim(t(this).find(".tabledit-span").text());e.is("select")?e.find("option").filter(function(){return t.trim(t(this).text())===n}).attr("selected",!0):e.val(n),v.view(this)})},submit:function(e){var n=a(o.buttons.edit.action);n!==!1&&(t(e).each(function(){var e=t(this).find(".tabledit-input");e.is("select")?t(this).find(".tabledit-span").text(t.trim(e.find("option:selected").text())):t(this).find(".tabledit-span").text(e.val()),v.view(this)}),d=t(e).parent("tr"))}},y={reset:function(){s.find(".tabledit-confirm-button").hide(),s.find(".tabledit-delete-button").removeClass("active").blur()},submit:function(e){y.reset(e),t(e).parent("tr").find("input.tabledit-identifier").attr("disabled",!1);var n=a(o.buttons["delete"].action);t(e).parents("tr").find("input.tabledit-identifier").attr("disabled",!0),n!==!1&&(t(e).parent("tr").addClass("tabledit-deleted-row"),t(e).parent("tr").addClass(o.mutedClass).find(".tabledit-toolbar button:not(.tabledit-restore-button)").attr("disabled",!0),t(e).find(".tabledit-restore-button").show(),r=t(e).parent("tr"))},confirm:function(e){s.find("td.tabledit-edit-mode").each(function(){g.reset(this)}),t(e).find(".tabledit-delete-button").addClass("active"),t(e).find(".tabledit-confirm-button").show()},restore:function(e){t(e).parent("tr").find("input.tabledit-identifier").attr("disabled",!1);var n=a(o.buttons.restore.action);t(e).parents("tr").find("input.tabledit-identifier").attr("disabled",!0),n!==!1&&(t(e).parent("tr").removeClass("tabledit-deleted-row"),t(e).parent("tr").removeClass(o.mutedClass).find(".tabledit-toolbar button").attr("disabled",!1),t(e).find(".tabledit-restore-button").hide(),u=t(e).parent("tr"))}};return m.columns.identifier(),m.columns.editable(),m.columns.toolbar(),o.onDraw(),o.deleteButton&&(s.on("click","button.tabledit-delete-button",function(e){if(e.handled!==!0){e.preventDefault();var n=t(this).hasClass("active"),i=t(this).parents("td");y.reset(i),n||y.confirm(i),e.handled=!0}}),s.on("click","button.tabledit-confirm-button",function(e){if(e.handled!==!0){e.preventDefault();var n=t(this).parents("td");y.submit(n),e.handled=!0}})),o.restoreButton&&s.on("click","button.tabledit-restore-button",function(e){e.handled!==!0&&(e.preventDefault(),y.restore(t(this).parents("td")),e.handled=!0)}),o.editButton?(s.on("click","button.tabledit-edit-button",function(e){if(e.handled!==!0){e.preventDefault();var n=t(this),i=n.hasClass("active");g.reset(s.find("td.tabledit-edit-mode")),i||t(n.parents("tr").find("td.tabledit-view-mode").get().reverse()).each(function(){v.edit(this)}),e.handled=!0}}),s.on("click","button.tabledit-save-button",function(e){e.handled!==!0&&(e.preventDefault(),g.submit(t(this).parents("tr").find("td.tabledit-edit-mode")),e.handled=!0)})):(s.on(o.eventType,"tr:not(.tabledit-deleted-row) td.tabledit-view-mode",function(t){t.handled!==!0&&(t.preventDefault(),g.reset(s.find("td.tabledit-edit-mode")),v.edit(this),t.handled=!0)}),s.on("change","select.tabledit-input:visible",function(e){e.handled!==!0&&(g.submit(t(this).parent("td")),e.handled=!0)}),t(document).on("click",function(t){var e=s.find(".tabledit-edit-mode");e.is(t.target)||0!==e.has(t.target).length||g.reset(s.find(".tabledit-input:visible").parent("td"))})),s.on("keypress",function(t){var e=s.find(".tabledit-input:visible"),n=s.find(".tabledit-confirm-button");if(e.length>0)var i=e.parents("td");else{if(!(n.length>0))return;var i=n.parents("td")}switch(t.keyCode){case 9:o.editButton||(g.submit(i),v.edit(i.closest("td").next()));break;case 13:t.preventDefault(),g.submit(i);break;case 27:g.reset(i),y.reset(i)}}),t("textarea").on("change keyup keydown",function(){var e=t(this).val().length,n=t(this).attr("maxlength");if("undefined"!=typeof n&&n!==!1&&n.length>0){var e=n-e;t(this).parent().find(".countno_").text(e)}}),this},destroy:function(e){var n=this;e.debug&&console.log("Tabledit Destroy -> Element:",t(this)),n.find(".tabledit-toolbar-column").remove(),n.find(".toolbar").remove(),n.find("td").each(function(){var e=t(this).find(".tabledit-input");if(0!=e.length)var n=t.trim(t(this).find(".tabledit-span").text());else var n=t.trim(t(this).text());t(this).html(n)})},update:function(i){var a=t(this).data(e);if(!a)return void console.log("Tabledit Update -> Data: EditTable must be initialized before setting options");var i=t.extend(!0,a,i);i.debug&&console.log("Tabledit Update -> Element:",t(this)),i.debug&&console.log("Tabledit Update -> Settings: ",i);var s=t.parseJSON(JSON.stringify(i,["debug"]));n.destroy.apply(this,[s]),n.init.apply(this,[i])}};t.fn.Tabledit=function(e){return n[e]?n[e].apply(this,Array.prototype.slice.call(arguments,1)):"object"!=typeof e&&e?void t.error("Method "+e+" does not exist on jQuery.Tabledit"):n.init.apply(this,arguments)},t.fn.Tabledit.defaults={url:window.location.href,editmethod:"post",deletemethod:"post",toolbarHeaderClass:"",toolbarClass:"btn-toolbar",groupClass:"btn-group btn-group-sm",inputClass:"form-control input-sm",dangerClass:"danger",successClass:"success",mutedClass:"text-muted",noEditClass:"noedit",eventType:"click",rowIdentifier:"id",hideIdentifier:!1,autoFocus:!0,lang:"en",debug:!1,escapehtml:!0,editButton:!0,deleteButton:!0,saveButton:!0,restoreButton:!0,buttons:{edit:{"class":"btn btn-sm btn-link",html:'<span class="icon icon-n-edit"></span>',action:"edit"},"delete":{"class":"btn btn-sm btn-link",html:'<span class="icon icon-delete-forever"></span>',action:"delete"},save:{"class":"btn btn-sm btn-success",html:""},restore:{"class":"btn btn-sm btn-warning",html:"Restore",action:"restore"},confirm:{"class":"btn btn-sm btn-danger",html:"Confirm"}},onDraw:function(){},onSuccess:function(){},onFail:function(){},onAlways:function(){},onAjax:function(){}},t.fn.Tabledit.langs={en:{btn_edit:"Edit",btn_delete:"Delete",btn_confirm:"Confirm",btn_save:"Save",btn_restore:"Restore",txt_action:"Actions",txt_nolimit:"Count of characters without limit",txt_allowchar:"Allowed count of characters %s",txt_remain:"characters remaining"},de:{btn_edit:"Editieren",btn_delete:"L&ouml;schen",btn_confirm:"Best&auml;tigen",btn_save:"Speichern",btn_restore:"Inhalt",txt_action:"Aktion",txt_nolimit:"",txt_allowchar:"",txt_remain:""},fr:{btn_edit:"Éditer",btn_delete:"Supprimer",btn_confirm:"Confirmer",btn_save:"Sauver",btn_restore:"Restaurer",txt_action:"Mode",txt_nolimit:"",txt_allowchar:"",txt_remain:""},cz:{btn_edit:"Editovat",btn_delete:"Odstranit",btn_confirm:"Potvrdit",btn_save:"Uložit",btn_restore:"Obnovit",txt_action:"Akce",txt_nolimit:"Počet znaků bez omezení",txt_allowchar:"Povoleno celkem %s znaků",txt_remain:"znak(ů) zbývá"}}}(jQuery);