	$('.save-chart-btn').click(function(e) {
        e.preventDefault();
        var click = $(this);
        $(this).closest('.ibox-content').find('canvas').get(0).toBlob(function(blob) {
            var heading = click.attr('data-name');
            var slug = click.attr('data-slug');
            fd = new FormData();
            fd.append('image', blob);
            fd.append('name', slug);
            $.ajax({  
                type: "POST",  
                url: "/save-image",  
                data: fd,
                processData: false,
                contentType: false,
                success: function(result) {
                    var name = click.attr('data-name');
                    var filename = click.attr('data-filename');
                    var sheetTitle = click.attr('data-sheettitle');
                  
                    window.location.href='/graph-export?name='+name+'&filename='+filename+'&image='+result.path+'&sheettitle='+sheetTitle
                }
            })
        });
    })


    var tableToExcel = (function() {
      var uri = 'data:application/vnd.ms-excel;base64,'
        , template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--><meta http-equiv="content-type" content="text/plain; charset=UTF-8"/></head><body><table><tr><td rowspan=28 colspan=18><img src="{imgsrc}" style="float:left;clear:none;margin-right:50px "/><td></tr></table></body></html>'
        , base64 = function(s) { return window.btoa(unescape(encodeURIComponent(s))) }
        , format = function(s, c) { return s.replace(/{(\w+)}/g, function(m, p) { return c[p]; }) }
      return function(imgsrc, name, heading) {
        var ctx = {worksheet: name || 'Worksheet',imgsrc: imgsrc, heading: heading}
        var blob = new Blob([format(template, ctx)]);
        var blobURL = window.URL.createObjectURL(blob);
        return blobURL;
      }
    })()
