<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\UserType;
use Illuminate\Support\Facades\DB;

class UserTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        UserType::truncate();
        $userTypes = ['Administrator', 'Technician', 'Read Only', 'Employee', 'Super Admin', 'Super User'];
        foreach ($userTypes as $userType) {
            UserType::create([
                'name' => $userType,
                'is_admin' => ($userType == 'Employee') ? 0 : 1,
                'guard_name' => 'web'
            ]);
        }
    }
}
