<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\PermissionCategory;
use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class UserLoginHistoryPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'User Login History'
        ];
        $category = PermissionCategory::updateOrCreate(['name' => 'Settings']);

        $adminRole = Role::firstOrCreate(['name' => 'Administrator']);
        $superAdminRole = Role::firstOrCreate(['name' => 'Super Admin']);
        $superUserRole = Role::firstOrCreate(['name' => 'Super User']);

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'permission_category_id' => $category->id]);
        }

        $adminRole->givePermissionTo($permissions);
        $superAdminRole->givePermissionTo($permissions);
        $superUserRole->givePermissionTo($permissions);
    }
}
