<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\PermissionCategory;
use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SupportPagePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        app()['cache']->forget('spatie.permission.cache');
        $permissionNames = ['Support Page View'];
        $category = PermissionCategory::firstOrCreate(['name' => 'Misc'])->id;

        $permissionCount = Permission::where('permission_category_id', $category)->count();

        $adminRole = Role::firstOrCreate(['name' => 'Administrator']);
        $superAdminRole = Role::firstOrCreate(['name' => 'Super Admin']);
        $superUserRole = Role::firstOrCreate(['name' => 'Super User']);

        $i = 1;
        foreach ($permissionNames as $name) {
            $permission = Permission::updateOrCreate(
                ['name' => $name],
                [
                    'order' => $permissionCount + $i,
                    'guard_name' => 'web',
                    'permission_category_id' => $category
                ]
            );
            // Check if the permission exists before assigning it to roles
            if ($permission->exists) {
                $adminRole->givePermissionTo($name);
                $superAdminRole->givePermissionTo($name);
                $superUserRole->givePermissionTo($name);
                $i++;
            }
        }
    }
}
