<?php

namespace Database\Seeders\SoftwareLicense;

use App\Models\PermissionCategory;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\DB;

class SoftwarePermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Reset cached roles and permissions.
        app()['cache']->forget('spatie.permission.cache');

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        $softwarePermissions = [
            'Settings' => [
                "permisssions" => [
                    "Software Assets Category Manage",
                    "Software Assets Manufacturer Manage",
                    "Software Assets Subscription Manage",
                    "Software Assets View",
                    "Software Assets Manage",
                    "Vendor Manage"
                ]
            ],
        ];

        $superAdminRole = Role::firstOrCreate(['name' => 'Super Admin']);

        $allPermissions = [];
        $loop = 0;

        foreach ($softwarePermissions as $category => $permissions) {
            $category = PermissionCategory::updateOrCreate([
                'name' => $category,
                'order' => $loop++
            ]);

            $permissionLoop = 0;

            foreach ($permissions['permisssions'] as $permission) {
                Permission::firstOrCreate([
                    'name' => $permission,
                    'order' => $permissionLoop++,
                    'guard_name' => 'web',
                    'permission_category_id' => $category->id
                ]);

                $allPermissions[] = $permission;
            }
        }

        $superAdminRole->givePermissionTo($allPermissions);
    }
}
