<?php

namespace Database\Seeders\SoftwareLicense;

use App\Models\SoftwareLicense\PaymentMethod;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;

class PaymentMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        PaymentMethod::truncate();
        Schema::enableForeignKeyConstraints();
        PaymentMethod::insert($this->getPaymentMethods());
    }

    /**
     * Retrieve payment methods
     * 
     * @return array
     */
    private function getPaymentMethods(): array
    {
        return [
            ['name' => 'Credit card', 'code' => 'credit-card'],
            ['name' => 'ACH', 'code' => 'ach'],
            ['name' => 'Wire', 'code' => 'wire'],
            ['name' => 'Paypal', 'code' => 'paypal'],
            ['name' => 'Other', 'code' => 'other'],
        ];
    }
}
