<?php

namespace Database\Seeders;

use App\Models\SlackNotificationCredential;
use Illuminate\Database\Seeder;

class SlackNotificationChannelsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        SlackNotificationCredential::truncate();

        $credentials = [
            ['name' => 'Loaner asset due next week user notification', 'slug' => 'loaner_asset_due_next_week_user_notification', 'channel_name' => 'Direct Message'],
            ['name' => 'Loaner asset overdue admin notification', 'slug' => 'loaner_asset_overdue_admin_notification'],
        ];

        foreach ($credentials as $credential) {
            SlackNotificationCredential::firstOrCreate(['name' => $credential['name']], [
                'slug' => $credential['slug'],
                'channel_name' => $credential['channel_name'] ?? null
            ]);
        }
    }
}
