<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\PermissionCategory;
use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SecurityToolsPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'Security Tools View',
            'Crowdstrike Reports View'
        ];
        $category = PermissionCategory::updateOrCreate(['name' => 'Security']);

        $adminRole = Role::firstOrCreate(['name' => 'Administrator']);
        $superAdminRole = Role::firstOrCreate(['name' => 'Super Admin']);

        foreach ($permissions as $permission) {
            $order = Permission::where('permission_category_id', $category->id)->max('order');
            Permission::firstOrCreate(['name' => $permission], ['permission_category_id' => $category->id, 'order' => $order + 1]);
        }

        $adminRole->givePermissionTo($permissions);
        $superAdminRole->givePermissionTo($permissions);
    }
}
