<?php

namespace Database\Seeders;

use App\Models\PermissionCategory;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\DB;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()['cache']->forget('spatie.permission.cache');
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('role_has_permissions')->truncate();
        Permission::truncate();


        $superAdminPermissions = [

            'Dashboard' => [
                "permisssions" => [
                    "Dashboard View"
                ]
            ],

            'Asset Management' => [
                "permisssions" => [
                    "Bulk Upload",
                    "IT Assets Create",
                    "IT Assets Edit",
                    "Mobile Assets View",
                    "Mobile Assets Create",
                    "Mobile Assets Edit",
                    "IT Assets View",
                    "Inventory Control View",
                    "ASN - Cdw",
                    "Cdw Mapping",
                    "ASN - Assets View",
                    "ASN Hardware Mapping",
                    "ASN Accessories Mapping",
                    "ASN Unwanted Parts Mapping",
                    // "AV Assets View",
                    // "Network Assets View",
                    // "Research Assets View"
                ]
            ],
            'Accessories' => [
                "permisssions" => [
                    "Accessories View",
                    "Accessories Edit",
                ]
            ],
            'Locations' => [
                "permisssions" => [
                    "Locations View",
                    "Locations Edit",
                ]
            ],
            'Users' => [
                "permisssions" => [
                    "People View",
                    "People Edit",
                ]
            ],
            'Team Report' => [
                "permisssions" => [
                    "Employee Landing Page",
                    "Team Report",
                ]
            ],
            'Reports' => [
                "permisssions" => [
                    "Reports View",
                    "Reports Edit",
                ],
            ],
            'Report Generator' => [
                "permisssions" => [
                    "Report Generator View",
                    "Report Generator Edit"
                ]
            ],
            'Notifications' => [
                "permisssions" => [
                    "Notifications View",
                ]
            ],
            'Settings' => [
                "permisssions" => [
                    "Settings View",
                    "API Users View",
                    "API Users Manage",
                    "Software Assets Category View",										
                    "Software Assets Category Manage",										
                    "Software Assets Vendor View",										
                    "Software Assets Vendor Manage",
                    "Software Assets Manufacturer Manage",										
                    "Software Assets View",									
                    "Software Assets Manage",
                ]
            ],

            'Third Party Integrations' => [
                "permisssions" => [
                    "API Credentials View",
                    "API Credentials Edit",
                ]
            ],
            'Access Roles' => [
                "permisssions" => [
                    "Access Levels View",
                    "Access Levels Edit",
                ]
            ],
            'Asset Settings' => [
                "permisssions" => [
                    "Asset Type View",
                    "Asset Type Edit",
                    "Asset Tab View",
                    "Asset Tab Edit",
                    "EOL Certificates Upload",
                    "Attributes View",
                    "Attributes Edit",
                    "Hardware Standards & Technical Specs View",
                    "Hardware Standards & Technical Specs Edit",
                    "Mobile Carrier View",
                    "Mobile Carrier Edit",
                ]
            ],
            'Location Settings' => [
                "permisssions" => [
                    "Site Code View",
                    "Site Code Edit",
                    "Locations Create",
                    "Region Edit",
                    "State View",
                    "State Edit",
                    "Location Type View",
                    "Location Type Edit",
                    "Region View",
                ]
            ],
            'Logs' => [
                "permisssions" => [
                    "Failed Ticket Logs View",
                ]
            ],
            'Toolbox' => [
                "permisssions" => [
                    "Bulk Assign",
                    "Bulk Install",
                    "Bulk Loans",
                    "Bulk Hold",
                    "Bulk Asset Attribute Update",
                    "On Hand Statuses",
                    "Toolbox View",
                    "Bulk Lost Stolen",
                    "Bulk Move",
                    "Bulk Return",
                    "Bulk Link",
                    "Bulk Create Link Mobile",
                    "Purge Assets",
                    "Bulk Status Update"
                ]
            ],
            'Termination Tools' => [
                "permisssions" => [
                    "Terminations",
                ]
            ],
            'Misc' => [
                "permisssions" => [
                    "Change Created Date",
                    "Discovery Tools",
                    "Administrators View",
                    "Administrators Edit",
                    "New Hire",
                ]
            ],

        ];

        $permissions = [
            'IT Assets View',
            'IT Assets Create',
            'IT Assets Edit',
            'Mobile Assets View',
            'Mobile Assets Create',
            'Mobile Assets Edit',
            'Accessories View',
            'Accessories Edit',
            'Reports View',
            'Reports Edit',
            'Locations View',
            'Locations Edit',
            'People View',
            'People Edit',
            'Administrators View',
            'Administrators Edit',
            'Access Levels View',
            'Access Levels Edit',
            'Attributes View',
            'Attributes Edit',
            'Hardware Standards & Technical Specs View',
            'Hardware Standards & Technical Specs Edit',
            'Report Generator View',
            'Report Generator Edit',
            'API Credentials View',
            'API Credentials Edit',
            'Mobile Carrier View',
            'Mobile Carrier Edit',
            'Location Type View',
            'Location Type Edit',
            'Region View',
            'Region Edit',
            'Asset Type View',
            'Asset Type Edit',
            'Site Code View',
            'Site Code Edit',
            'Asset Tab View',
            'Asset Tab Edit',
            'Bulk Assign',
            'Bulk Install',
            'Bulk Loans',
            'Locations Create',
            'Change Created Date',
            'Bulk Hold',
            'Bulk Asset Attribute Update',
            'Bulk Upload',
            "Bulk Status Update",
            'Dashboard View',
            'Notifications View',
            'Settings View',
            'On Hand Statuses',
            'Failed Ticket Logs View',
        ];


        $technicianPermissions = [
            'IT Assets View',
            'IT Assets Create',
            'IT Assets Edit',
            'Mobile Assets View',
            'Mobile Assets Create',
            'Mobile Assets Edit',
            'Accessories View',
            'Accessories Edit',
            'Reports View',
            'Reports Edit',
            'Locations View',
            'Locations Edit',
            'People View',
            'People Edit',
            'Administrators View',
            'Administrators Edit',
            'Access Levels View',
            'Access Levels Edit',
            'Attributes View',
            'Attributes Edit',
            'Hardware Standards & Technical Specs View',
            'Hardware Standards & Technical Specs Edit',
            'Report Generator View',
            'Report Generator Edit',
            'API Credentials View',
            'API Credentials Edit',
            'Mobile Carrier View',
            'Mobile Carrier Edit',
            'Location Type View',
            'Location Type Edit',
            'Region View',
            'Region Edit',
            'Asset Type View',
            'Asset Type Edit',
            'Site Code View',
            'Site Code Edit',
            'Asset Tab View',
            'Asset Tab Edit',
            'Bulk Assign',
            'Bulk Install',
            'Bulk Loans',
            'Locations Create',
            'Change Created Date',
            'Bulk Hold',
            'Bulk Asset Attribute Update',
            'Bulk Upload',
            "Bulk Status Update",
            'Dashboard View',
            'Notifications View',
            'Settings View',
            'On Hand Statuses',
            'Failed Ticket Logs View',
        ];

        $readOnlyPermissions = [
            'IT Assets View',
            'Mobile Assets View',
            'Accessories View',
            'Reports View',
            'Locations View',
            'People View',
            'Administrators View',
            'Attributes View',
            'Hardware Standards & Technical Specs View',
            'Report Generator View',
        ];

        $adminRole = Role::firstOrCreate(['name' => 'Administrator']);
        $technicianRole = Role::firstOrCreate(['name' => 'Technician']);
        $readOnlyRole = Role::firstOrCreate(['name' => 'Read Only']);
        $superAdminRole = Role::firstOrCreate(['name' => 'Super Admin']);
        $superUserRole = Role::firstOrCreate(['name' => 'Super User']);
        $allPermissions = [];
        $loop = 0;
        foreach ($superAdminPermissions as $category => $permissions) {
            $category = PermissionCategory::updateOrCreate([
                'name' => $category,
                'order' => $loop++
            ]);
            $permissionLoop = 0;
            foreach ($permissions['permisssions'] as $permission) {
                Permission::Create([
                    'name' => $permission,
                    'order' => $permissionLoop++,
                    'guard_name' => 'web',
                    'permission_category_id' => $category->id
                ]);
                $allPermissions[] = $permission;
            }
        }

        $adminRole->syncPermissions($permissions);
        $technicianRole->syncPermissions($technicianPermissions);
        $readOnlyRole->syncPermissions($readOnlyPermissions);
        $superAdminRole->syncPermissions($allPermissions);
        $superUserRole->syncPermissions($allPermissions);
    }
}
