<?php

namespace Database\Seeders\Reports;

use Illuminate\Database\Seeder;
use App\Models\PermissionCategory;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class ConsumptionReportsPermissionSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()['cache']->forget('spatie.permission.cache');
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        if (Permission::where('name', 'Consumption Reports New')->first()) {
            Permission::where('name', 'Consumption Reports New')->delete();       
        } 

        $superAdminRole = Role::firstOrCreate(['name' => 'Super Admin']);
        $administratorRole = Role::firstOrCreate(['name' => 'Administrator']);
        $reportsCategoryId = PermissionCategory::where('name', 'Reports')->value('id');
        $reportsPermissionCount = Permission::where('permission_category_id', $reportsCategoryId)->count();
        Permission::where('name', 'Consumption Reports')->delete();

        if (!Permission::where('name', 'Consumption Reports')->first()) {
                Permission::firstOrCreate([
                    'name' => 'Consumption Reports',
                    'order' => $reportsPermissionCount + 1,
                    'guard_name' => 'web',
                    'permission_category_id' => $reportsCategoryId
                ]);
        }
        
        $superAdminRole->givePermissionTo(['Consumption Reports']);
        $administratorRole->givePermissionTo(['Consumption Reports']);
    }
}
