<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\PermissionCategory;
use Schema;
use Illuminate\Database\Seeder;
use DB;

class PermissionCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        app()['cache']->forget('spatie.permission.cache');
        Schema::disableForeignKeyConstraints();
        PermissionCategory::truncate();
        // Permission::truncate();

        $permission_categories = [

            'Dashboard' => [
                "permisssions" => [
                    "Dashboard View"
                ]
            ],

            'Asset Management' => [
                "permisssions" => [
                    "Bulk Upload",
                    "IT Assets Create",
                    "IT Assets Edit",
                    "Mobile Assets View",
                    "Mobile Assets Create",
                    "Mobile Assets Edit",
                    "IT Assets View",
                    "Inventory Control View",
                    "ASN - Cdw",
                    "Cdw Mapping",
                    // "AV Assets View",
                    // "Network Assets View",
                    // "Research Assets View"
                ]
            ],
            'Accessories' => [
                "permisssions" => [
                    "Accessories View",
                    "Accessories Edit",
                ]
            ],
            'Locations' => [
                "permisssions" => [
                    "Locations View",
                    "Locations Edit",
                ]
            ],
            'Users' => [
                "permisssions" => [
                    "People View",
                    "People Edit",
                ]
            ],
            'Team Report' => [
                "permisssions" => [
                    "Employee Landing Page",
                    "Team Report",
                ]
            ],
            'Reports' => [
                "permisssions" => [
                    "Reports View",
                    "Reports Edit",
                ],
            ],
            'Report Generator' => [
                "permisssions" => [
                    "Report Generator View",
                    "Report Generator Edit"
                ]
            ],
            'Notifications' => [
                "permisssions" => [
                    "Notifications View",
                ]
            ],
            'Settings' => [
                "permisssions" => [
                    "Settings View",
                    "API Users View",
                    "API Users Manage",
                ]
            ],

            'Third Party Integrations' => [
                "permisssions" => [
                    "API Credentials View",
                    "API Credentials Edit",
                ]
            ],
            'Access Roles' => [
                "permisssions" => [
                    "Access Levels View",
                    "Access Levels Edit",
                ]
            ],
            'Asset Settings' => [
                "permisssions" => [
                    "Asset Type View",
                    "Asset Type Edit",
                    "Asset Tab View",
                    "Asset Tab Edit",
                    "EOL Certificates Upload",
                    "Attributes View",
                    "Attributes Edit",
                    "Hardware Standards & Technical Specs View",
                    "Hardware Standards & Technical Specs Edit",
                    "Mobile Carrier View",
                    "Mobile Carrier Edit",
                ]
            ],
            'Location Settings' => [
                "permisssions" => [
                    "Site Code View",
                    "Site Code Edit",
                    "Locations Create",
                    "Region Edit",
                    "State View",
                    "State Edit",
                    "Location Type View",
                    "Location Type Edit",
                    "Region View",
                ]
            ],
            'Logs' => [
                "permisssions" => [
                    "Failed Ticket Logs View",
                ]
            ],
            'Toolbox' => [
                "permisssions" => [
                    "Bulk Assign",
                    "Bulk Install",
                    "Bulk Loans",
                    "Bulk Hold",
                    "Bulk Asset Attribute Update",
                    "On Hand Statuses",
                    "Toolbox View",
                    "Bulk Lost Stolen",
                    "Bulk Move",
                    "Bulk Return",
                    "Bulk Link",
                    "Bulk Create Link Mobile",
                    "Purge Assets",
                    "Bulk Status Update"
                ]
            ],
            'Termination Tools' => [
                "permisssions" => [
                    "Terminations",
                ]
            ],
            'Misc' => [
                "permisssions" => [
                    "Change Created Date",
                    "Discovery Tools",
                    "Administrators View",
                    "Administrators Edit",
                    "New Hire",
                    "Assets Health View"
                ]
            ],

        ];

        $loop = 0;
        foreach ($permission_categories as $category => $permissions) {
            $category = PermissionCategory::updateOrCreate([
                'name' => $category,
                'order' => $loop++
            ]);
            $permissionLoop = 0;
            foreach ($permissions['permisssions'] as $permission) {
                Permission::where(['name' => $permission])->update([
                    'order' => $permissionLoop++,
                    'permission_category_id' => $category->id
                ]);
            }
        }
    }
}
