<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class OAuthScopesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $scopes = [
            [
                'name' => 'View Assets',
                'slug' => 'view-assets',
                'description' => 'View Assets',
            ],
            [
                'name' => 'Create Asset',
                'slug' => 'create-asset',
                'description' => 'Create New Asset',
            ],
            [
                'name' => 'Update Asset',
                'slug' => 'update-asset',
                'description' => 'Update Asset',
            ],
            [
                'name' => 'Create User',
                'slug' => 'create-user',
                'description' => 'Create New User',
            ],
            [
                'name' => 'Update User',
                'slug' => 'update-user',
                'description' => 'Update User',
            ],
            [
                'name' => 'Create Location',
                'slug' => 'create-location',
                'description' => 'Create New Location',
            ],
        ];

        foreach ($scopes as $scope) {
            DB::table('oauth_scopes')->insert($scope);
        }
    }
}
