<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\LockStatus;

class LockStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $statuses = [
            [
                'name' => 'None',
                'slug' => 'none',
            ],
            [
                'name' => 'Lock Requested',
                'slug' => 'lock_requested',
            ],
            [
                'name' => 'Lock Pending',
                'slug' => 'lock_pending',
            ],
            [
                'name' => 'Lock Confirmed',
                'slug' => 'lock_confirmed',
            ],
            [
                'name' => 'Lock Failed',
                'slug' => 'lock_failed',
            ],
            [
                'name' => 'Not Found in MDM',
                'slug' => 'not_found_in_mdm',
            ],
        ];

        foreach ($statuses as $status) {
            LockStatus::create([
                'name' => $status['name'],
                'slug' => $status['slug'],
                'status' => 1,
            ]);
        }
    }
}
