<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\PermissionCategory;
use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class HrCollectionsReportPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissionNames = ['HR Collections Report'];
        $permissionCategoryId = PermissionCategory::where('name', 'Termination Tools')->pluck('id');
        $superAdminRole = Role::where('name', 'Super Admin')->first();
        $adminRole = Role::where('name', 'Administrator')->first();

        foreach ($permissionNames as $name) {
            $permission = Permission::firstOrCreate([
                'name' => $name,
                'guard_name' => 'web',
                'permission_category_id' => $permissionCategoryId[0]
            ]);
            $superAdminRole->givePermissionTo($permission);
            $adminRole->givePermissionTo($permission);
        }
    }
}
