<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Manufacturer;
use App\Models\MakeAndModel;
use App\Models\AssetType;

class HardwareStandardSeeder extends Seeder
{
    public function run()
    {
        Manufacturer::truncate();
        MakeAndModel::truncate();
        $hardwares = [
        
        	'Apple' => [
        		'iPhone 5',
        		'iPhone 5s',
        		'iPhone 6',
        		'iPhone 7',
        		'iWatch'
        	],

        	'Samsung' => [
        		'Gear',
        		'S6',
        		'S8',
        		'Note 4'
        	]
        ];

        foreach($hardwares as $manufacturer => $models) {
        	
        	$manufacturer_id = Manufacturer::firstOrCreate([
        		'name' => $manufacturer,
                'slug' => str_slug($manufacturer, '_'),
        	])->id;

        	foreach($models as $model) {
        		MakeAndModel::firstOrCreate([
        			'manufacturer_id' => $manufacturer_id,
        			'name' => $model,
                    'slug' => str_slug($model, '_'),
                    'asset_type_id' => AssetType::inRandomOrder()->first()->id,
        		]);
        	}
        }
    }
}
