<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\EmployeeType;

class EmployeeTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        EmployeeType::truncate();
        
        $employeeTypes = [
            ['name' => 'Contractor', 'slug' => 'contractor'],
            ['name' => 'Temporary', 'slug' => 'temporary'],
            ['name' => 'Full Time', 'slug' => 'full_time'],
            ['name' => 'Intern', 'slug' => 'intern']
        ];

        foreach($employeeTypes as $employeeType) {
        	EmployeeType::create([
        		'name' => $employeeType['name'],
                'slug' => $employeeType['slug'],
        	]);
        }
    }
}
