<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\PermissionCategory;
use App\Models\Role;
use Illuminate\Database\Seeder;

class CloudAssetsPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissionNames = ['Cloud Assets View'];
        $permissionCategoryId = PermissionCategory::firstOrCreate(['name' => 'Cloud Assets'])->pluck('id');
        $superAdminRole = Role::where('name', 'Super Admin')->first();
        $adminRole = Role::where('name', 'Administrator')->first();

        foreach ($permissionNames as $name) {
            $permission = Permission::firstOrCreate([
                'name' => $name,
                'guard_name' => 'web',
                'permission_category_id'=> $permissionCategoryId[0],
            ]);
            $superAdminRole->givePermissionTo($permission);
            $adminRole->givePermissionTo($permission);
        }
    }
}
