<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Asset;

class ChangeAssetTagSeeder extends Seeder
{

	/**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
    	$assets = Asset::get();
        foreach ($assets as $asset) {
            $assetTag = $asset->asset_tag;
            if (!preg_match('/^[a-zA-Z]+[a-zA-Z0-9._]+$/', $assetTag)) {
	            $assetTagLength = strlen($assetTag);
	            while($assetTagLength < 6) {
	                $assetTag = '0'.$assetTag;
	                $assetTagLength++;    
	            }
	            $asset = Asset::find($asset->id);
	            $asset->asset_tag = $assetTag;
	            $asset->save();
	        }
        }
    }
}