<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Carrier;

class CarrierSeed extends Seeder
{
    public function run()
    {

    	Carrier::truncate();

        $carriers = [
        	'AT&T',
        	'Verizon',
        	'Sprint',
        	'T-Mobile',
        	'Other'
        ];

        foreach($carriers as $carrier) {
        	Carrier::create([
        		'name' => $carrier,
        		'slug' => str_slug($carrier, '_')
        	]);
        }
    }
}
