<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AssetType;
use App\Models\AssetTab;

class AssetTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $types = [
            'IT Assets' => [
                'Laptop',
                'Desktop',
                'Monitor',
                'Printer'
            ],
            'Mobile Assets' => [
                'Tablet',
                'Mobile Device',
                'Mobile Phone Number'
            ],
            'AV Asset' => [
                'Desktop',
                'Tablet',
                'AV Audio',
                'AV Video',
                'AV Control',
                'AV Display'
            ],
            
            'Network Asset' => [
                'Network'
            ]
        ];

        foreach($types as $tab => $types) {

            $tab_id = AssetTab::firstOrCreate([
                'name' => $tab,
                'slug' => str_slug($tab, '_'),
            ])->id;

        	foreach($types as $type) {
                $assetType = AssetType::firstOrCreate([
                    'slug' => str_slug($type, '_')
                ],
            	[
                    'name' => $type,
                    'parent' => ($type == 'Mobile Phone Number') ? 0 : 1,
                    'leased' => $type == 'Servers' ? 1 : 0
            	]);
                $assetType->assetTabs()->attach($tab_id);
            }
        }

        AssetType::firstOrCreate([
            'name'  => 'Accessories',
            'slug'  => 'accessories',
            'parent'=> 1,
            'leased'=> 0
        ]);

    }
}
