<?php

namespace Database\Seeders;

use App\Models\Asset;
use App\Models\AssetHistory;
use App\Models\AssetStatus;
use App\Models\Location;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class AssetStatusUpdateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $assets = Asset::where('id', '>', 6792)->where('id', '<', 7780)->get();
        $userId = User::admin()->inRandomOrder()->first()->id;
        foreach ($assets as $asset) {
            $assetStatus = AssetStatus::inRandomOrder()->whereNotIn('slug', ['brand_new', 'cdw_in_transit'])->first();
            $user = ($assetStatus->has_user) ? User::people()->inRandomOrder()->first()->id : null;
            $location = null;
            if ($assetStatus->has_location) {
                $location = ($assetStatus->slug == 'installed') ? Location::installLocations()->inRandomOrder()->first()->id : Location::warehouses()->inRandomOrder()->first()->id;
            }

            $loaner_return_date = in_array($assetStatus->slug, ['loaned']) ? parse_date_from_db_datetime(Carbon::now()->addYears(config('date.period.loaner'))) : '';

            $description = __('history.Created', [
                'assetname' => $asset->serial_no,
                'assetid' => $asset->id,
            ]);
            AssetHistory::create([
                'asset_id' => $asset->id,
                'user_id' => $userId,
                'ticket_no' => random_int(9999, 99999999),
                'ticket_service_provider' => config('ticket-integration.service'),
                'action' => 'status_updated',
                'old_location_id' => $asset->location_id,
                'new_location_id' => $location,
                'old_user_id' => $asset->user_id,
                'new_user_id' => $user,
                'old_asset_status_id' => $asset->asset_status_id,
                'new_asset_status_id' => $assetStatus->id,
                'old_loaner_return_date' => $asset->loaner_return_date,
                'new_loaner_return_date' => $loaner_return_date,
                'old_value' => $asset->assetStatus->name,
                'new_value' => $assetStatus->name,
                'description' => $description
            ]);

            $asset->update([
                'asset_status_id' => $assetStatus->id,
                'user_id' => $user,
                'location_id' => $location,
                'loaner_return_date' => $loaner_return_date
            ]);
        }
    }
}
