<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AssetStatus;

class AssetStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        AssetStatus::truncate();

        $statuses = [
            'Assigned',
            'Brand New',
            'Damaged',
            'End of Life',
            'End of Life - Data Wiped',
            'Installed',
            'In Repair',
            'Legal Hold',
            'Loaned',
            'Loaner',
            'Pending Return',
            'RMA Returned',
            'Retain Hold',
            'Stolen / Lost',
            'Used',
        ];

        $locationSlugs = ['brand_new', 'damaged', 'end_of_life', 'installed', 'legal_hold', 'retain_hold', 'stolen_lost', 'used', 'loaner', 'in_repair'];
        $userSlugs = ['assigned', 'legal_hold', 'loaned', 'pending_return', 'retain_hold', 'stolen_lost', 'damaged'];
        $canBeLinked = ['assigned', 'brand_new', 'installed', 'loaned', 'used'];
        $canBeReturned = ['assigned', 'installed', 'loaned'];

        foreach ($statuses as $status) {
            $slug = str_slug($status, '_');
            AssetStatus::create([
                'name' => $status,
                'slug' => $slug,
                'has_location' => in_array($slug, $locationSlugs) ? 1 : 0,
                'has_user' => in_array($slug, $userSlugs) ? 1 : 0,
                'can_be_linked' => in_array($slug, $canBeLinked) ? 1 : 0,
                'can_be_returned' => in_array($slug, $canBeReturned) ? 1 : 0,
            ]);
        }
    }
}
