<?php

namespace Database\Seeders;

use App\Models\Asset;
use App\User;
use Illuminate\Database\Seeder;

class AssetLoadSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Asset::factory()->hasAssetHistory(1, function (array $attributes, Asset $asset) {
            $description = __('history.Created', [
                'assetname' => $asset->serial_no,
                'assetid' => $asset->id,
            ]);

            return [
                'user_id' => User::admin()->inRandomOrder()->first()->id,
                'ticket_no' => random_int(9999, 99999999),
                'action' => 'created',
                'new_asset_status_id' => $asset->asset_status_id,
                'new_value' => $asset->assetStatus->name,
                'description' => $description
            ];
        })->count(1000)->create();
    }
}
