<?php

namespace Database\Seeders;

use App\Events\BulkUpdates;
use App\Models\Asset;
use App\User;
use App\Models\AssetHistory;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class AssetHistorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $assets = Asset::get();
        foreach ($assets as $asset) {

            $description = __('history.Created', [
                'assetname' => $asset->serial_no,
                'assetid' => $asset->id,
            ]);

            $assetHistory = [
                'user_id' => User::admin()->inRandomOrder()->first()->id,
                'asset_id' => $asset->id,
                'ticket_no' => $asset->ticket_no,
                'ticket_service_provider' => config('ticket-integration.service'),
                'action' => 'created',
                'description' => $description,
                'created_at'  => Carbon::now()->format('Y-m-d H:i:s'),
                'updated_at'  => Carbon::now()->format('Y-m-d H:i:s'),
            ];
            event(new BulkUpdates($assetHistory));
        }
    }
}
